/*
 * Decompiled with CFR 0.152.
 */
package de.ovgu.dke.mocca.util;

import de.ovgu.dke.mocca.api.context.Context;
import de.ovgu.dke.mocca.api.context.ContextConnectionListener;
import java.net.URI;
import java.util.Collections;
import java.util.Set;
import java.util.concurrent.ConcurrentSkipListSet;

public class ContextConnectionSupport
implements ContextConnectionListener {
    private final Set<ContextConnectionListener> listeners = new ConcurrentSkipListSet<ContextConnectionListener>();

    public Set<ContextConnectionListener> getListeners() {
        return Collections.unmodifiableSet(this.listeners);
    }

    public void addListener(ContextConnectionListener listener) {
        this.listeners.add(listener);
    }

    public void removeListener(ContextConnectionListener listener) {
        this.listeners.remove(this.listeners);
    }

    @Override
    public void contextConnected(Context ctx, URI peer) {
        for (ContextConnectionListener listener : this.listeners) {
            listener.contextConnected(ctx, peer);
        }
    }

    @Override
    public void contextDisconnected(Context ctx, URI peer) {
        for (ContextConnectionListener listener : this.listeners) {
            listener.contextDisconnected(ctx, peer);
        }
    }

    @Override
    public void contextDialogOpen(Context ctx, String id) {
        for (ContextConnectionListener listener : this.listeners) {
            listener.contextDialogOpen(ctx, id);
        }
    }

    @Override
    public void contextDialogClose(Context ctx, String id) {
        for (ContextConnectionListener listener : this.listeners) {
            listener.contextDialogClose(ctx, id);
        }
    }
}

