/*
 * Decompiled with CFR 0.152.
 */
package de.ovgu.dke.mocca.impl;

import de.ovgu.dke.mocca.api.command.Command;
import java.net.URI;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;

class CommandImpl
implements Command {
    private final URI command;
    private final Map<String, String> parameters;

    public CommandImpl(URI command, Properties parameters) {
        if (command == null) {
            throw new IllegalArgumentException("Command may not be null!");
        }
        this.command = command;
        this.parameters = new HashMap<String, String>();
        if (parameters != null) {
            for (Map.Entry<Object, Object> e : parameters.entrySet()) {
                if (e.getKey() == null || e.getValue() == null) continue;
                String key = e.getKey().toString();
                String value = e.getValue().toString();
                this.parameters.put(key, value);
            }
        }
    }

    @Override
    public URI getCommand() {
        return this.command;
    }

    @Override
    public String getParameter(String key) {
        return this.parameters.get(key);
    }

    @Override
    public Collection<String> getParameters() {
        return this.parameters.keySet();
    }

    public String toString() {
        StringBuffer str = new StringBuffer();
        if (this.parameters != null) {
            for (String key : this.parameters.keySet()) {
                if (str.length() != 0) {
                    str.append(", ");
                }
                str.append(key);
                str.append("=");
                str.append(this.parameters.get(key));
            }
            str.append(")");
            str.insert(0, " (");
        }
        str.insert(0, this.command.toASCIIString());
        return str.toString();
    }
}

