/*
 * Decompiled with CFR 0.152.
 */
package de.ovgu.dke.mocca.glue;

import de.ovgu.dke.glue.api.serialization.SerializationException;
import de.ovgu.dke.glue.util.serialization.TextSerializationHelpers;
import de.ovgu.dke.mocca.api.command.Command;
import de.ovgu.dke.mocca.api.command.CommandException;
import de.ovgu.dke.mocca.glue.CommandSerializer;
import de.ovgu.dke.mocca.impl.DefaultCommandFactory;
import de.ovgu.dke.mocca.util.MoccaHelper;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.Properties;

public class TextCommandSerializer
extends CommandSerializer {
    public Object serialize(Object o) throws SerializationException {
        if (!(o instanceof Command)) {
            throw new ClassCastException("Serializer expected Command implementation, got " + (o == null ? "null" : o.getClass().getCanonicalName()) + " instead!");
        }
        Command cmd = (Command)o;
        StringBuilder text = new StringBuilder();
        if (cmd.getCommand() == null) {
            throw new SerializationException("Command did not contain a command identifier!");
        }
        text.append(cmd.getCommand().toASCIIString());
        Properties props = MoccaHelper.cmdParams2Props(cmd);
        String s_props = TextSerializationHelpers.encodeProperties((Properties)props);
        if (!s_props.isEmpty()) {
            text.append("\n");
            text.append(s_props);
        }
        return text.toString();
    }

    public Object deserialize(Object o) throws SerializationException {
        Properties params;
        URI command;
        String text = (String)o;
        int _cmdidx = text.indexOf(10);
        String _command = _cmdidx < 0 ? text : text.substring(0, _cmdidx);
        try {
            command = new URI(_command);
        }
        catch (URISyntaxException e) {
            throw new SerializationException("Identifier URI is invalid: " + e.getMessage(), (Throwable)e);
        }
        if (_cmdidx > 0) {
            String _params = text.substring(_cmdidx + 1);
            params = TextSerializationHelpers.decodeProperties((String)_params);
        } else {
            params = new Properties();
        }
        DefaultCommandFactory fac = new DefaultCommandFactory();
        try {
            return fac.createCommand(command, params);
        }
        catch (CommandException e) {
            throw new SerializationException("Error creating command instance: " + e.getMessage(), (Throwable)e);
        }
    }

    public String getFormat() {
        return "string";
    }
}

