/*
 * Decompiled with CFR 0.152.
 */
package de.ovgu.dke.mocca.glue;

import de.ovgu.dke.glue.api.serialization.SerializationProvider;
import de.ovgu.dke.glue.api.serialization.Serializer;
import de.ovgu.dke.glue.api.transport.PacketHandlerFactory;
import de.ovgu.dke.glue.api.transport.SchemaRecord;
import de.ovgu.dke.glue.api.transport.SchemaRegistry;
import de.ovgu.dke.glue.api.transport.TransportException;
import de.ovgu.dke.glue.api.transport.TransportRegistry;
import de.ovgu.dke.glue.util.serialization.SingleSerializerProvider;
import de.ovgu.dke.mocca.api.MoccaException;
import de.ovgu.dke.mocca.api.MoccaRuntime;
import de.ovgu.dke.mocca.api.command.Command;
import de.ovgu.dke.mocca.api.command.CommandFactory;
import de.ovgu.dke.mocca.api.command.CommandHandlerRegistry;
import de.ovgu.dke.mocca.api.context.Context;
import de.ovgu.dke.mocca.glue.CommandPacketHandlerFactory;
import de.ovgu.dke.mocca.glue.GlueContextImpl;
import de.ovgu.dke.mocca.glue.TextCommandSerializer;
import de.ovgu.dke.mocca.impl.DefaultCommandFactory;
import de.ovgu.dke.mocca.util.CommandHandlerSupport;
import de.ovgu.dke.mocca.util.ContextDirectory;
import java.net.URI;
import java.util.Properties;

public class GlueMoccaRuntimeImpl
implements MoccaRuntime {
    private final CommandHandlerRegistry globalHandlers = new CommandHandlerSupport();
    private final CommandFactory commandFactory = new DefaultCommandFactory();

    @Override
    public void init(Properties env) throws MoccaException {
        SingleSerializerProvider serializers = SingleSerializerProvider.of((Serializer)new TextCommandSerializer());
        try {
            PacketHandlerFactory packetHandlers = CommandPacketHandlerFactory.forRuntime(this);
            TransportRegistry.getInstance().loadTransportFactory("de.ovgu.dke.glue.xmpp.transport.XMPPTransportFactory", env, TransportRegistry.AS_DEFAULT, TransportRegistry.DEFAULT_KEY);
            SchemaRecord schema = SchemaRecord.valueOf((String)"http://dke.ovgu.de/mocca/core/CommandMessage", (PacketHandlerFactory)packetHandlers, (SerializationProvider)serializers);
            SchemaRegistry.getInstance().registerSchemaRecord(schema);
        }
        catch (TransportException e) {
            throw new MoccaException("Error initializing the GLUE transport: " + e.getMessage(), e);
        }
        catch (ClassNotFoundException e) {
            throw new MoccaException("Could not load the XMPP transport class!", e);
        }
    }

    @Override
    public void dispose() throws MoccaException {
        TransportRegistry.getInstance().disposeAll();
    }

    @Override
    public Context createContext() throws MoccaException {
        return GlueContextImpl.create(TransportRegistry.getDefaultTransportFactory(), ContextDirectory.INSTANCE);
    }

    @Override
    public Command createCommand(URI command, Properties parameters) throws MoccaException {
        return this.commandFactory.createCommand(command, parameters);
    }

    @Override
    public CommandHandlerRegistry getCommandHandlerRegistry() {
        return this.globalHandlers;
    }
}

