/*
 * Decompiled with CFR 0.152.
 */
package de.ovgu.dke.mocca.glue;

import de.ovgu.dke.glue.api.transport.Packet;
import de.ovgu.dke.glue.api.transport.PacketHandler;
import de.ovgu.dke.glue.api.transport.PacketThread;
import de.ovgu.dke.mocca.api.MoccaException;
import de.ovgu.dke.mocca.api.MoccaRuntime;
import de.ovgu.dke.mocca.api.command.Command;
import de.ovgu.dke.mocca.api.command.CommandHandler;
import de.ovgu.dke.mocca.api.context.Context;
import de.ovgu.dke.mocca.glue.GlueContextImpl;
import de.ovgu.dke.mocca.util.ContextDirectory;

public class CommandPacketHandler
implements PacketHandler {
    private final MoccaRuntime runtime;

    public CommandPacketHandler(MoccaRuntime runtime) {
        this.runtime = runtime;
    }

    public void handle(PacketThread packetThread, Packet packet) {
        Command cmd = (Command)packet.getPayload();
        Context ctx = ContextDirectory.INSTANCE.retrieve(packetThread.toString());
        try {
            if (ctx == null) {
                ctx = GlueContextImpl.createFromPacketThread(packetThread, ContextDirectory.INSTANCE);
            }
            CommandHandler hnd = ctx.getCommandHandlerRegistry().getCommandHandler(cmd.getCommand());
            hnd = this.runtime.getCommandHandlerRegistry().getCommandHandler(cmd.getCommand());
            hnd.handleCommand(cmd, ctx);
        }
        catch (MoccaException e) {
            e.printStackTrace();
        }
    }
}

