/*
 * Copyright 2012 Stefan Haun, Andreas Nürnberger
 * 
 *      Data and Knowledge Engineering Group, 
 * 		Faculty of Computer Science,
 *		Otto-von-Guericke University,
 *		Magdeburg, Germany
 *
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package de.ovgu.dke.mocca.impl;

import java.net.URI;
import java.util.Properties;

import de.ovgu.dke.mocca.api.command.Command;
import de.ovgu.dke.mocca.api.command.CommandException;
import de.ovgu.dke.mocca.api.command.CommandFactory;

/**
 * Default factory for MOCCA commands.
 * 
 * @author Stefan Haun (stefan.haun@ovgu.de)
 * 
 */
public class DefaultCommandFactory implements CommandFactory {

	@Override
	public Command createCommand(URI command, Properties parameters)
			throws CommandException {
		if (command == null)
			throw new NullPointerException("Cannot create command without id!");

		return new CommandImpl(command, parameters);
	}

}
