/*
 * Copyright 2012 Stefan Haun, Andreas Nürnberger
 * 
 *      Data and Knowledge Engineering Group, 
 * 		Faculty of Computer Science,
 *		Otto-von-Guericke University,
 *		Magdeburg, Germany
 *
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package de.ovgu.dke.mocca.impl;

import java.net.URI;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.Map.Entry;
import java.util.Properties;

import de.ovgu.dke.mocca.api.command.Command;

/**
 * Bean implementation of the {@link Command} interface.
 * 
 * @author Stefan Haun (stefan.haun@ovgu.de)
 *
 */
class CommandImpl implements Command {
    private final URI command;
    private final Map<String, String> parameters;

    public CommandImpl(URI command, Properties parameters) {
        super();

        if (command == null)
            throw new IllegalArgumentException("Command may not be null!");

        this.command = command;
        this.parameters = new HashMap<String, String>();

        if (parameters != null)
            for (Entry<Object, Object> e : parameters.entrySet())
                if (e.getKey() != null && e.getValue() != null) {
                    final String key = e.getKey().toString();
                    final String value = e.getValue().toString();
                    this.parameters.put(key, value);
                }
    }

    @Override
    public URI getCommand() {
        return command;
    }

    @Override
    public String getParameter(String key) {
        return parameters.get(key);
    }

    @Override
    public Collection<String> getParameters() {
        return (Collection<String>) parameters.keySet();
    }

    @Override
    public String toString() {
        StringBuffer str = new StringBuffer();

        if (parameters != null) {
            for (final String key : parameters.keySet()) {
                if (str.length() != 0)
                    str.append(", ");

                str.append(key);
                str.append("=");
                str.append(parameters.get(key));
            }
            str.append(")");
            str.insert(0, " (");
        }

        str.insert(0, command.toASCIIString());

        return str.toString();
    }
}
