/*
 * Copyright 2012 Stefan Haun, Andreas Nürnberger
 * 
 *      Data and Knowledge Engineering Group, 
 * 		Faculty of Computer Science,
 *		Otto-von-Guericke University,
 *		Magdeburg, Germany
 *
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package de.ovgu.dke.mocca.glue;

import de.ovgu.dke.glue.api.serialization.Serializer;

/**
 * <p>
 * Base serializer for all <code>Command</code>s. An overriding class needs to
 * implement the serialization for a specific format.
 * </p>
 * 
 * <p>
 * The schema is http://dke.ovgu.de/mocca/CommandMessage/text
 * </p>
 * 
 * @author Stefan Haun (stefan.haun@ovgu.de)
 * 
 */
public abstract class CommandSerializer implements Serializer {
	/**
	 * The schema prefix for MOCCA command messages.
	 */
	public static final String SCHEMA = "http://dke.ovgu.de/mocca/core/CommandMessage";
}
