/*
 * Copyright 2012 Stefan Haun, Andreas Nürnberger
 * 
 *      Data and Knowledge Engineering Group, 
 * 		Faculty of Computer Science,
 *		Otto-von-Guericke University,
 *		Magdeburg, Germany
 *
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package de.ovgu.dke.mocca.glue;

import de.ovgu.dke.glue.api.transport.Packet;
import de.ovgu.dke.glue.api.transport.PacketHandler;
import de.ovgu.dke.glue.api.transport.PacketThread;
import de.ovgu.dke.mocca.api.MoccaException;
import de.ovgu.dke.mocca.api.MoccaRuntime;
import de.ovgu.dke.mocca.api.command.Command;
import de.ovgu.dke.mocca.api.command.CommandHandler;
import de.ovgu.dke.mocca.api.context.Context;
import de.ovgu.dke.mocca.util.ContextDirectory;

/**
 * GLUE Packet handler for Command payload. Handles distribution to the
 * respective contexts.
 * 
 * @author Stefan Haun (stefan.haun@ovgu.de)
 */
public class CommandPacketHandler implements PacketHandler {
	private final MoccaRuntime runtime;

	public CommandPacketHandler(MoccaRuntime runtime) {
		this.runtime = runtime;
	}

	@Override
	public void handle(PacketThread packetThread, Packet packet) {
		Command cmd = (Command) packet.getPayload();

		// TODO kann man das ContextDirectory auch ohne Singleton verwenden?
		// get the context
		Context ctx = ContextDirectory.INSTANCE.retrieve(packetThread.toString());

		try {
			// if context is null, we got an unknown thread; create new context
			if (ctx == null) {
				ctx = GlueContextImpl
						.createFromPacketThread(packetThread, ContextDirectory.INSTANCE);
			}
			// look for command handler in the context
			CommandHandler hnd = ctx.getCommandHandlerRegistry()
					.getCommandHandler(cmd.getCommand());

			// if not found: use from global registry
			hnd = runtime.getCommandHandlerRegistry().getCommandHandler(
					cmd.getCommand());

			// TODO error if no command found

			hnd.handleCommand(cmd, ctx);
		} catch (MoccaException e) {
			// TODO Auto-generated catch block
			e.printStackTrace();
		}
	}

}
