package de.ovgu.dke.mocca.api.context;

import java.net.URI;

/**
 * Listener for context connectivity changes.
 * 
 * @author Stefan Haun (stefan.haun@ovgu.de)
 * 
 */
public interface ContextConnectionListener {
	/**
	 * A context has been connected to a peer.
	 * 
	 * @param ctx
	 *            The context.
	 * @param peer
	 *            The peer.
	 * @throws NullPointerException
	 *             if one of the arguments is null.
	 */
	public void contextConnected(Context ctx, URI peer);

	/**
	 * A context has been disconnected from a peer.
	 * 
	 * @param ctx
	 *            The context.
	 * @param peer
	 *            The peer.
	 * @throws NullPointerException
	 *             if one of the arguments is null.
	 */
	public void contextDisconnected(Context ctx, URI peer);

	/**
	 * A dialog (e.g. GLUE packet thread) has been opened.
	 * 
	 * @param ctx
	 *            The context.
	 * @param id
	 *            A unique ID of the dialog.
	 * @throws NullPointerException
	 *             if one of the arguments is null.
	 */
	public void contextDialogOpen(Context ctx, String id);

	/**
	 * A dialog (e.g. GLUE packet thread) has been closed.
	 * 
	 * @param ctx
	 *            The context.
	 * @param id
	 *            A unique ID of the dialog.
	 * @throws NullPointerException
	 *             if one of the arguments is null.
	 */
	public void contextDialogClose(Context ctx, String id);

}
