/*
 * Copyright 2012 Stefan Haun, Andreas Nürnberger
 * 
 *      Data and Knowledge Engineering Group, 
 * 		Faculty of Computer Science,
 *		Otto-von-Guericke University,
 *		Magdeburg, Germany
 *
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package de.ovgu.dke.mocca.api.command;

import java.net.URI;
import java.util.Properties;

/**
 * Factory for MOCCA commands.
 * 
 * @author Stefan Haun (stefan.haun@ovgu.de)
 * 
 */
public interface CommandFactory {
	/**
	 * Create a new MOCCA command instance.
	 * 
	 * @param command
	 *            The command identifier.
	 * @param parameters
	 *            The command's parameters.
	 * @return A command instance.
	 * @throws CommandException
	 *             if the command cannot be created.
	 * @throws NullPointerException
	 *             (optional) if the command argument is null.
	 * @throws IllegalArgumentException
	 *             (optional) if the arguments are invalid.
	 */
	public Command createCommand(URI command, Properties parameters)
			throws CommandException;
}
