/*
 * Copyright 2012 Stefan Haun, Andreas Nürnberger
 * 
 *      Data and Knowledge Engineering Group, 
 * 		Faculty of Computer Science,
 *		Otto-von-Guericke University,
 *		Magdeburg, Germany
 *
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package de.ovgu.dke.mocca.api.command;

import java.net.URI;
import java.util.Collection;

import net.jcip.annotations.Immutable;

/**
 * Generic interface for a command.
 * 
 * @author Stefan Haun (stefan.haun@ovgu.de)
 */
@Immutable
public interface Command {
	/**
	 * Get the command.
	 * 
	 * @return the command encoded in the message.
	 */
	public URI getCommand();

	/**
	 * Get a specific property.
	 * 
	 * @param key
	 *            The property name.
	 * @return The property value or <code>null</code> if not available.
	 */
	public String getParameter(final String key);

	/**
	 * Get the list of available parameters
	 * 
	 * @return List of parameters which can be queried by
	 *         <code>getParameter</code>.
	 */
	public Collection<String> getParameters();
}
