/*
 * Copyright 2012 Stefan Haun, Andreas Nürnberger
 * 
 *      Data and Knowledge Engineering Group, 
 * 		Faculty of Computer Science,
 *		Otto-von-Guericke University,
 *		Magdeburg, Germany
 *
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package de.ovgu.dke.mocca.api;

/**
 * Base exception for any MOCCA exception.
 *  
 * @author Stefan Haun (stefan.haun@ovgu.de)
 *
 */
public class MoccaException extends Exception {
	private static final long serialVersionUID = 582961556382343886L;

	public MoccaException() {
	}

	public MoccaException(String message) {
		super(message);
	}

	public MoccaException(Throwable cause) {
		super(cause);
	}

	public MoccaException(String message, Throwable cause) {
		super(message, cause);
	}
}
