/*
 * Decompiled with CFR 0.152.
 */
package de.ottonow.secretsmanager.propertysource;

import com.amazonaws.services.secretsmanager.AWSSecretsManager;
import com.amazonaws.services.secretsmanager.model.GetSecretValueRequest;
import com.amazonaws.services.secretsmanager.model.GetSecretValueResult;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.google.common.cache.CacheBuilder;
import com.google.common.cache.CacheLoader;
import com.google.common.cache.LoadingCache;
import java.util.List;
import java.util.concurrent.TimeUnit;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 1, 13}, bv={1, 0, 3}, k=1, d1={"\u0000.\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u000b\n\u0002\b\u0002\u0018\u0000 \u00102\u00020\u0001:\u0001\u0010B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0010\u0010\u000b\u001a\u0004\u0018\u00010\u00012\u0006\u0010\f\u001a\u00020\u0007J\u0010\u0010\r\u001a\u00020\u00072\u0006\u0010\f\u001a\u00020\u0007H\u0002J\u0010\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\f\u001a\u00020\u0007H\u0002R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000RN\u0010\u0005\u001aB\u0012\f\u0012\n \b*\u0004\u0018\u00010\u00070\u0007\u0012\f\u0012\n \b*\u0004\u0018\u00010\u00070\u0007 \b* \u0012\f\u0012\n \b*\u0004\u0018\u00010\u00070\u0007\u0012\f\u0012\n \b*\u0004\u0018\u00010\u00070\u0007\u0018\u00010\u00060\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0011"}, d2={"Lde/ottonow/secretsmanager/propertysource/AwsSecretManagerSource;", "", "client", "Lcom/amazonaws/services/secretsmanager/AWSSecretsManager;", "(Lcom/amazonaws/services/secretsmanager/AWSSecretsManager;)V", "loadingCache", "Lcom/google/common/cache/LoadingCache;", "", "kotlin.jvm.PlatformType", "objectMapper", "Lcom/fasterxml/jackson/databind/ObjectMapper;", "getProperty", "propertyName", "getSecretValueString", "isJsonProperty", "", "Companion", "aws-secrets-manager-property-source"})
public final class AwsSecretManagerSource {
    private final ObjectMapper objectMapper;
    private final LoadingCache<String, String> loadingCache;
    private final AWSSecretsManager client;
    @NotNull
    public static final String SEPARATOR_JSON_PROPERTY_NAME = ".";
    public static final Companion Companion = new Companion(null);

    @Nullable
    public final Object getProperty(@NotNull String propertyName) {
        String string;
        Intrinsics.checkParameterIsNotNull((Object)propertyName, (String)"propertyName");
        boolean isJsonProperty = this.isJsonProperty(propertyName);
        List propertyNameSplit = StringsKt.split$default((CharSequence)propertyName, (String[])new String[]{SEPARATOR_JSON_PROPERTY_NAME}, (boolean)false, (int)0, (int)6, null);
        String propertyNameWithoutDot = (String)propertyNameSplit.get(0);
        String secretAsString = (String)this.loadingCache.get((Object)propertyNameWithoutDot);
        if (!isJsonProperty) {
            string = secretAsString;
        } else {
            JsonNode jsonTree = this.objectMapper.readTree(secretAsString);
            String jsonPropertyName = (String)propertyNameSplit.get(1);
            string = jsonTree.get(jsonPropertyName).textValue();
        }
        return string;
    }

    private final String getSecretValueString(String propertyName) {
        GetSecretValueResult secretValue;
        GetSecretValueRequest getSecretValueRequest = new GetSecretValueRequest().withSecretId(propertyName);
        GetSecretValueResult getSecretValueResult = secretValue = this.client.getSecretValue(getSecretValueRequest);
        Intrinsics.checkExpressionValueIsNotNull((Object)getSecretValueResult, (String)"secretValue");
        String string = getSecretValueResult.getSecretString();
        Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"secretValue.secretString");
        return string;
    }

    private final boolean isJsonProperty(String propertyName) {
        return StringsKt.contains$default((CharSequence)propertyName, (CharSequence)SEPARATOR_JSON_PROPERTY_NAME, (boolean)false, (int)2, null);
    }

    public AwsSecretManagerSource(@NotNull AWSSecretsManager client) {
        Intrinsics.checkParameterIsNotNull((Object)client, (String)"client");
        this.client = client;
        this.objectMapper = new ObjectMapper();
        this.loadingCache = CacheBuilder.newBuilder().expireAfterWrite(1L, TimeUnit.MINUTES).build((CacheLoader)new CacheLoader<String, String>(this){
            final /* synthetic */ AwsSecretManagerSource this$0;

            @Nullable
            public String load(@NotNull String key) {
                Intrinsics.checkParameterIsNotNull((Object)key, (String)"key");
                return AwsSecretManagerSource.access$getSecretValueString(this.this$0, key);
            }
            {
                this.this$0 = $outer;
            }
        });
    }

    @NotNull
    public static final /* synthetic */ String access$getSecretValueString(AwsSecretManagerSource $this, @NotNull String propertyName) {
        return $this.getSecretValueString(propertyName);
    }

    @Metadata(mv={1, 1, 13}, bv={1, 0, 3}, k=1, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0005"}, d2={"Lde/ottonow/secretsmanager/propertysource/AwsSecretManagerSource$Companion;", "", "()V", "SEPARATOR_JSON_PROPERTY_NAME", "", "aws-secrets-manager-property-source"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

