/*
 * Decompiled with CFR 0.152.
 */
package de.ottonow.secretsmanager.propertysource;

import com.amazonaws.services.secretsmanager.AWSSecretsManager;
import com.amazonaws.services.secretsmanager.AWSSecretsManagerClientBuilder;
import de.ottonow.secretsmanager.propertysource.AwsSecretManagerPropertySource;
import de.ottonow.secretsmanager.propertysource.AwsSecretManagerSource;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.springframework.boot.SpringApplication;
import org.springframework.boot.env.EnvironmentPostProcessor;
import org.springframework.core.env.ConfigurableEnvironment;
import org.springframework.core.env.PropertySource;

@Metadata(mv={1, 1, 13}, bv={1, 0, 3}, k=1, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u0000 \t2\u00020\u0001:\u0001\tB\u0005\u00a2\u0006\u0002\u0010\u0002J\u0018\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\bH\u0016\u00a8\u0006\n"}, d2={"Lde/ottonow/secretsmanager/propertysource/AwsSecretManagerPropertySourceEnvironmentPostProcessor;", "Lorg/springframework/boot/env/EnvironmentPostProcessor;", "()V", "postProcessEnvironment", "", "environment", "Lorg/springframework/core/env/ConfigurableEnvironment;", "application", "Lorg/springframework/boot/SpringApplication;", "Companion", "aws-secrets-manager-property-source"})
public final class AwsSecretManagerPropertySourceEnvironmentPostProcessor
implements EnvironmentPostProcessor {
    private static final String PARAMETER_STORE_PROPERTY_SOURCE_NAME = "AWSParameterStorePropertySource";
    private static boolean initialized;
    public static final Companion Companion;

    public void postProcessEnvironment(@NotNull ConfigurableEnvironment environment, @NotNull SpringApplication application) {
        Intrinsics.checkParameterIsNotNull((Object)environment, (String)"environment");
        Intrinsics.checkParameterIsNotNull((Object)application, (String)"application");
        if (!initialized) {
            AWSSecretsManager client;
            AWSSecretsManager aWSSecretsManager = client = (AWSSecretsManager)AWSSecretsManagerClientBuilder.standard().build();
            Intrinsics.checkExpressionValueIsNotNull((Object)aWSSecretsManager, (String)"client");
            AwsSecretManagerPropertySource awsSecretManagerPropertySource = new AwsSecretManagerPropertySource(PARAMETER_STORE_PROPERTY_SOURCE_NAME, new AwsSecretManagerSource(aWSSecretsManager));
            environment.getPropertySources().addFirst((PropertySource)awsSecretManagerPropertySource);
            initialized = true;
        }
    }

    static {
        Companion = new Companion(null);
    }

    @Metadata(mv={1, 1, 13}, bv={1, 0, 3}, k=1, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u000b\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0007"}, d2={"Lde/ottonow/secretsmanager/propertysource/AwsSecretManagerPropertySourceEnvironmentPostProcessor$Companion;", "", "()V", "PARAMETER_STORE_PROPERTY_SOURCE_NAME", "", "initialized", "", "aws-secrets-manager-property-source"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

