/*
 * Decompiled with CFR 0.152.
 */
package de.otto.synapse.translator;

import com.fasterxml.jackson.core.JsonParseException;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.node.NullNode;
import com.fasterxml.jackson.databind.node.ObjectNode;
import com.fasterxml.jackson.databind.node.TextNode;
import de.otto.synapse.message.Message;
import de.otto.synapse.translator.Encoder;
import de.otto.synapse.translator.MessageFormat;
import de.otto.synapse.translator.ObjectMappers;
import java.io.IOException;

public class TextEncoder
implements Encoder<String> {
    private final MessageFormat messageFormat;

    public TextEncoder() {
        this(MessageFormat.defaultMessageFormat());
    }

    public TextEncoder(MessageFormat messageFormat) {
        this.messageFormat = messageFormat;
    }

    @Override
    public String apply(Message<String> message) {
        return this.encode(message, this.messageFormat);
    }

    protected String encode(Message<String> message, MessageFormat messageFormat) {
        switch (messageFormat) {
            case V1: {
                return message.getPayload();
            }
            case V2: {
                return TextEncoder.encodeV2(message);
            }
        }
        throw new IllegalStateException("Unsupported MessageFormat " + (Object)((Object)messageFormat));
    }

    private String encode(Message<String> message) {
        return this.encode(message, MessageFormat.defaultMessageFormat());
    }

    private static String encodeV2(Message<String> message) {
        ObjectMapper mapper = ObjectMappers.currentObjectMapper();
        try {
            ObjectNode root = mapper.createObjectNode();
            root.put("_synapse_msg_format", "v2");
            root.set("_synapse_msg_key", (JsonNode)TextEncoder.encodeKeysV2(message, mapper));
            root.set("_synapse_msg_headers", TextEncoder.encodeHeadersV2(message, mapper));
            root.set("_synapse_msg_payload", TextEncoder.encodePayloadV2(message, mapper));
            return root.toString();
        }
        catch (IOException e) {
            throw new IllegalStateException(String.format("Cannot encode message %s", message), e);
        }
    }

    private static ObjectNode encodeKeysV2(Message<String> message, ObjectMapper mapper) {
        ObjectNode keyNode = mapper.createObjectNode();
        keyNode.put("partitionKey", message.getKey().partitionKey());
        keyNode.put("compactionKey", message.getKey().compactionKey());
        return keyNode;
    }

    private static JsonNode encodeHeadersV2(Message<String> message, ObjectMapper mapper) {
        return (JsonNode)mapper.convertValue(message.getHeader().getAll(), JsonNode.class);
    }

    private static JsonNode encodePayloadV2(Message<String> message, ObjectMapper mapper) throws IOException {
        Object jsonPayload;
        try {
            jsonPayload = message.getPayload() == null ? NullNode.getInstance() : mapper.readTree(message.getPayload());
        }
        catch (JsonParseException e) {
            jsonPayload = new TextNode(message.getPayload());
        }
        return jsonPayload;
    }
}

