/*
 * Decompiled with CFR 0.152.
 */
package de.otto.synapse.logging;

import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.MDC;

public class LogHelper {
    public static void trace(Logger logger, Map<String, Object> contexts, String message, Object[] msgParams) {
        LogHelper.log(logger, LogLevel.TRACE, contexts, message, msgParams, null);
    }

    public static void info(Logger logger, Map<String, Object> contexts, String message, Object[] msgParams) {
        LogHelper.log(logger, LogLevel.INFO, contexts, message, msgParams, null);
    }

    public static void warn(Logger logger, Map<String, Object> contexts, String message, Object[] msgParams) {
        LogHelper.log(logger, LogLevel.INFO, contexts, message, msgParams, null);
    }

    public static void error(Logger logger, Map<String, Object> contexts, String message, Exception e) {
        LogHelper.log(logger, LogLevel.ERROR, contexts, message, null, e);
    }

    private static void log(Logger logger, LogLevel loglevel, Map<String, Object> contexts, String message, Object[] msgParams, Exception e) {
        LogHelper.putMDC(contexts);
        switch (loglevel) {
            case TRACE: {
                if (!logger.isTraceEnabled()) break;
                logger.trace(message != null ? message : "", msgParams);
                break;
            }
            case DEBUG: {
                if (!logger.isDebugEnabled()) break;
                logger.debug(message != null ? message : "", msgParams);
                break;
            }
            case INFO: {
                logger.info(message != null ? message : "", msgParams);
                break;
            }
            case WARN: {
                logger.warn(message != null ? message : "", msgParams);
                break;
            }
            case ERROR: {
                logger.error(message != null ? message : "", (Object)msgParams, (Object)e);
                break;
            }
        }
        LogHelper.removeMDC(contexts);
    }

    private static void putMDC(String mdcKey, Object value) {
        if (value != null) {
            MDC.put((String)mdcKey, (String)String.valueOf(value));
        }
    }

    private static void removeMDC(String mdcKey) {
        MDC.remove((String)mdcKey);
    }

    private static void putMDC(Map<String, Object> contexts) {
        if (contexts != null) {
            for (Map.Entry<String, Object> context : contexts.entrySet()) {
                LogHelper.putMDC(context.getKey(), context.getValue());
            }
        }
    }

    private static void removeMDC(Map<String, Object> contexts) {
        if (contexts != null) {
            for (String contextKey : contexts.keySet()) {
                LogHelper.removeMDC(contextKey);
            }
        }
    }

    public static double calculateMessagesPerSecond(long previousTime, long messagesSent) {
        long time = System.currentTimeMillis();
        long durationInMillis = time - previousTime;
        return 1.0 * (double)messagesSent / ((double)durationInMillis / 1000.0);
    }

    private static enum LogLevel {
        TRACE,
        DEBUG,
        INFO,
        WARN,
        ERROR;

    }
}

