/*
 * Decompiled with CFR 0.152.
 */
package de.otto.synapse.journal;

import com.google.common.base.CaseFormat;
import com.google.common.collect.ImmutableList;
import de.otto.synapse.journal.Journal;
import de.otto.synapse.messagestore.Indexers;
import de.otto.synapse.messagestore.MessageStore;
import de.otto.synapse.messagestore.MessageStores;
import de.otto.synapse.messagestore.OffHeapIndexingMessageStore;
import de.otto.synapse.state.StateRepository;

public class Journals {
    private Journals() {
    }

    public static Journal noOpJournal() {
        return new Journal(){

            @Override
            public String getName() {
                return "no-op";
            }

            @Override
            public ImmutableList<String> getJournaledChannels() {
                return ImmutableList.of();
            }

            @Override
            public MessageStore getMessageStore() {
                return MessageStores.emptyMessageStore();
            }
        };
    }

    public static Journal singleChannelJournal(StateRepository<?> stateRepository, String channelName) {
        return Journals.singleChannelJournal(stateRepository.getName(), channelName);
    }

    public static Journal singleChannelJournal(final String name, final String channelName) {
        return new Journal(){
            final MessageStore messageStore;
            {
                this.messageStore = new OffHeapIndexingMessageStore(Journals.nameFrom(channelName, "MessageStore"), Indexers.journalKeyIndexer());
            }

            @Override
            public String getName() {
                return name;
            }

            @Override
            public ImmutableList<String> getJournaledChannels() {
                return ImmutableList.of((Object)channelName);
            }

            @Override
            public MessageStore getMessageStore() {
                return this.messageStore;
            }
        };
    }

    public static Journal multiChannelJournal(StateRepository<?> stateRepository, String channelName, String ... moreChannelNames) {
        return Journals.multiChannelJournal(stateRepository.getName(), channelName, moreChannelNames);
    }

    public static Journal multiChannelJournal(final String name, final String channelName, final String ... moreChannelNames) {
        return new Journal(){
            final MessageStore messageStore;
            {
                this.messageStore = new OffHeapIndexingMessageStore(Journals.nameFrom(channelName, "MessageStore"), Indexers.journalKeyIndexer());
            }

            @Override
            public String getName() {
                return name;
            }

            @Override
            public ImmutableList<String> getJournaledChannels() {
                if (moreChannelNames != null && moreChannelNames.length > 0) {
                    return ImmutableList.builder().add((Object)channelName).add((Object[])moreChannelNames).build();
                }
                return ImmutableList.of((Object)channelName);
            }

            @Override
            public MessageStore getMessageStore() {
                return this.messageStore;
            }
        };
    }

    private static String nameFrom(String channelName, String suffix) {
        return CaseFormat.LOWER_HYPHEN.to(CaseFormat.UPPER_CAMEL, channelName) + suffix;
    }
}

