/*
 * Decompiled with CFR 0.152.
 */
package de.otto.synapse.eventsource;

import de.otto.synapse.eventsource.EventSource;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.context.SmartLifecycle;

public class EventSourceConsumerProcess
implements SmartLifecycle {
    private static final Logger LOG = LoggerFactory.getLogger(EventSourceConsumerProcess.class);
    private final List<EventSource> eventSources;
    private volatile boolean running = false;

    public EventSourceConsumerProcess(List<EventSource> eventSources) {
        this.eventSources = eventSources;
    }

    public boolean isAutoStartup() {
        return true;
    }

    public void stop(Runnable callback) {
        this.stop();
        callback.run();
    }

    public int getPhase() {
        return 0;
    }

    public void start() {
        int eventSourceCount;
        int n = eventSourceCount = this.eventSources != null ? this.eventSources.size() : 0;
        if (eventSourceCount > 0) {
            LOG.info("Initializing EventSourceConsumerProcess with {} EventSources", (Object)eventSourceCount);
            this.running = true;
            this.eventSources.forEach(eventSource -> {
                try {
                    LOG.info("Starting {}...", (Object)eventSource.getChannelName());
                    eventSource.consume();
                }
                catch (Exception e) {
                    LOG.error("Starting failed: " + e.getMessage(), (Throwable)e);
                    this.stop();
                }
            });
        } else {
            LOG.warn("Did not find any EventSource instances to execute");
            this.running = false;
        }
    }

    public void stop() {
        LOG.info("Shutting down...");
        this.eventSources.forEach(EventSource::stop);
        this.running = false;
        LOG.info("...done.");
    }

    public boolean isRunning() {
        return this.running;
    }
}

