/*
 * Decompiled with CFR 0.152.
 */
package de.otto.synapse.configuration;

import com.fasterxml.jackson.databind.ObjectMapper;
import de.otto.synapse.annotation.MessageInterceptorBeanPostProcessor;
import de.otto.synapse.configuration.MessageEndpointConfigurer;
import de.otto.synapse.configuration.SynapseProperties;
import de.otto.synapse.endpoint.DefaultReceiverHeadersInterceptor;
import de.otto.synapse.endpoint.DefaultSenderHeadersInterceptor;
import de.otto.synapse.endpoint.MessageInterceptorRegistry;
import de.otto.synapse.journal.Journal;
import de.otto.synapse.journal.JournalRegistry;
import de.otto.synapse.translator.ObjectMappers;
import java.util.List;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.context.ApplicationContext;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.Role;
import org.springframework.core.annotation.Order;

@Configuration
@EnableConfigurationProperties(value={SynapseProperties.class})
public class SynapseAutoConfiguration {
    private static final Logger LOG = LoggerFactory.getLogger(SynapseAutoConfiguration.class);
    private MessageInterceptorRegistry registry;

    @Bean
    @ConditionalOnMissingBean
    public ObjectMapper objectMapper() {
        return ObjectMappers.currentObjectMapper();
    }

    @Bean
    public MessageInterceptorRegistry messageInterceptorRegistry(ApplicationContext applicationContext) {
        if (this.registry == null) {
            this.registry = new MessageInterceptorRegistry();
            Map configurers = applicationContext.getBeansOfType(MessageEndpointConfigurer.class);
            if (configurers != null) {
                configurers.forEach((beanName, bean) -> {
                    LOG.info("Configuring MessageEndpointConfigurer '" + beanName + "'");
                    bean.configureMessageInterceptors(this.registry);
                });
            }
        }
        return this.registry;
    }

    @Bean
    public JournalRegistry journals(List<Journal> journals, MessageInterceptorRegistry registry) {
        return new JournalRegistry(journals, registry);
    }

    @Bean
    @Order(value=0x7FFFFFFF)
    @ConditionalOnMissingBean
    @ConditionalOnProperty(prefix="synapse.sender.default-headers", name={"enabled"}, havingValue="true", matchIfMissing=true)
    public DefaultSenderHeadersInterceptor defaultSenderHeadersInterceptor(SynapseProperties synapseProperties) {
        return new DefaultSenderHeadersInterceptor(synapseProperties);
    }

    @Bean
    @Order(value=0x7FFFFFFF)
    @ConditionalOnMissingBean
    @ConditionalOnProperty(prefix="synapse.receiver.default-headers", name={"enabled"}, havingValue="true", matchIfMissing=true)
    public DefaultReceiverHeadersInterceptor defaultReceiverHeadersInterceptor(SynapseProperties synapseProperties) {
        return new DefaultReceiverHeadersInterceptor(synapseProperties);
    }

    @Bean
    @Role(value=2)
    public MessageInterceptorBeanPostProcessor messageInterceptorBeanPostProcessor() {
        return new MessageInterceptorBeanPostProcessor();
    }
}

