/*
 * Decompiled with CFR 0.152.
 */
package de.otto.synapse.channel;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Maps;
import de.otto.synapse.channel.ShardPosition;
import java.io.Serializable;
import java.util.Arrays;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import javax.annotation.Nonnull;

public final class ChannelPosition
implements Serializable {
    private final ImmutableMap<String, ShardPosition> shardPositions;

    public static ChannelPosition fromHorizon() {
        return ChannelPosition.channelPosition((Iterable<ShardPosition>)ImmutableList.of());
    }

    public static ChannelPosition merge(ChannelPosition ... channelPositions) {
        if (channelPositions.length == 0) {
            return ChannelPosition.fromHorizon();
        }
        return ChannelPosition.merge(Arrays.asList(channelPositions));
    }

    public static ChannelPosition merge(ChannelPosition channelPosition, ShardPosition shardPosition) {
        return ChannelPosition.merge(channelPosition, ChannelPosition.channelPosition(shardPosition));
    }

    public static ChannelPosition merge(List<ChannelPosition> channelPositions) {
        if (channelPositions.isEmpty()) {
            throw new IllegalArgumentException("Parameter channelPositions must contain at least one element");
        }
        LinkedHashMap shardPositions = new LinkedHashMap();
        channelPositions.forEach(channelPosition -> channelPosition.shards().forEach(shardId -> shardPositions.put(shardId, channelPosition.shard((String)shardId))));
        return new ChannelPosition((Iterable<ShardPosition>)ImmutableList.copyOf(shardPositions.values()));
    }

    public static ChannelPosition channelPosition(ShardPosition ... shardPositions) {
        if (shardPositions.length == 0) {
            return ChannelPosition.fromHorizon();
        }
        return new ChannelPosition(Arrays.asList(shardPositions));
    }

    public static ChannelPosition channelPosition(Iterable<ShardPosition> shardPositions) {
        return new ChannelPosition(shardPositions);
    }

    protected ChannelPosition(Iterable<ShardPosition> shardPositions) {
        this.shardPositions = Maps.uniqueIndex(shardPositions, ShardPosition::shardName);
    }

    public Set<String> shards() {
        return this.shardPositions.keySet();
    }

    @Nonnull
    public ShardPosition shard(String shard) {
        return (ShardPosition)this.shardPositions.getOrDefault((Object)shard, (Object)ShardPosition.fromHorizon(shard));
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ChannelPosition that = (ChannelPosition)o;
        return Objects.equals(this.shardPositions, that.shardPositions);
    }

    public int hashCode() {
        return Objects.hash(this.shardPositions);
    }

    public String toString() {
        return "ChannelPosition{shardPositions=" + this.shardPositions + '}';
    }
}

