/*
 * Decompiled with CFR 0.152.
 */
package de.otto.synapse.annotation;

import de.otto.synapse.annotation.EventSourceConsumer;
import de.otto.synapse.consumer.MethodInvokingMessageConsumer;
import de.otto.synapse.eventsource.EventSource;
import java.lang.reflect.Method;
import java.util.Collections;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.aop.support.AopUtils;
import org.springframework.beans.BeansException;
import org.springframework.beans.factory.config.BeanPostProcessor;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ApplicationContextAware;
import org.springframework.context.ConfigurableApplicationContext;
import org.springframework.core.MethodIntrospector;
import org.springframework.core.Ordered;
import org.springframework.core.annotation.AnnotationUtils;

public class EventSourceConsumerBeanPostProcessor
implements BeanPostProcessor,
Ordered,
ApplicationContextAware {
    private static final Logger LOG = LoggerFactory.getLogger(EventSourceConsumerBeanPostProcessor.class);
    private final Set<Class<?>> nonAnnotatedClasses = Collections.newSetFromMap(new ConcurrentHashMap(64));
    private ConfigurableApplicationContext applicationContext;

    public int getOrder() {
        return Integer.MAX_VALUE;
    }

    public void setApplicationContext(ApplicationContext applicationContext) throws BeansException {
        if (applicationContext instanceof ConfigurableApplicationContext) {
            this.applicationContext = (ConfigurableApplicationContext)applicationContext;
        }
    }

    public Object postProcessBeforeInitialization(Object bean, String beanName) {
        if (!this.nonAnnotatedClasses.contains(bean.getClass())) {
            Class targetClass = AopUtils.getTargetClass((Object)bean);
            Map<Method, Set<EventSourceConsumer>> annotatedMethods = this.findMethodsAnnotatedWithEventSourceConsumer(targetClass);
            if (annotatedMethods.isEmpty()) {
                this.nonAnnotatedClasses.add(bean.getClass());
                LOG.trace("No @EventSourceConsumer annotations found on bean type: {}", bean.getClass());
            } else {
                this.registerEventConsumers(bean, beanName, annotatedMethods);
            }
        }
        return bean;
    }

    public Object postProcessAfterInitialization(Object bean, String beanName) {
        return bean;
    }

    private Map<Method, Set<EventSourceConsumer>> findMethodsAnnotatedWithEventSourceConsumer(Class<?> targetClass) {
        return MethodIntrospector.selectMethods(targetClass, method -> {
            Set<EventSourceConsumer> consumerAnnotations = this.consumerAnnotationsOf(method);
            return !consumerAnnotations.isEmpty() ? consumerAnnotations : null;
        });
    }

    private void registerEventConsumers(Object bean, String beanName, Map<Method, Set<EventSourceConsumer>> annotatedMethods) {
        for (Map.Entry<Method, Set<EventSourceConsumer>> entry : annotatedMethods.entrySet()) {
            Method method = entry.getKey();
            for (EventSourceConsumer consumerAnnotation : entry.getValue()) {
                this.matchingEventSourceFor(consumerAnnotation).register(this.eventConsumerFor(consumerAnnotation, method, bean));
            }
        }
        LOG.info("{} @EventSourceConsumer methods processed on bean {} : {}'", new Object[]{annotatedMethods.size(), beanName, annotatedMethods});
    }

    private Set<EventSourceConsumer> consumerAnnotationsOf(Method method) {
        HashSet<EventSourceConsumer> listeners = new HashSet<EventSourceConsumer>();
        EventSourceConsumer ann = (EventSourceConsumer)AnnotationUtils.findAnnotation((Method)method, EventSourceConsumer.class);
        if (ann != null) {
            listeners.add(ann);
        }
        return listeners;
    }

    private MethodInvokingMessageConsumer<?> eventConsumerFor(EventSourceConsumer annotation, Method annotatedMethod, Object bean) {
        return new MethodInvokingMessageConsumer(annotation.keyPattern(), annotation.payloadType(), bean, annotatedMethod);
    }

    private EventSource matchingEventSourceFor(EventSourceConsumer annotation) {
        return (EventSource)this.applicationContext.getBean(annotation.eventSource(), EventSource.class);
    }
}

