/*
 * Decompiled with CFR 0.152.
 */
package de.otto.synapse.annotation;

import com.google.common.base.CaseFormat;
import java.lang.annotation.Annotation;

public class BeanNameHelper {
    public static String beanNameFor(Class<? extends Annotation> annotationType, String channelName) {
        switch (annotationType.getSimpleName()) {
            case "EnableMessageLogReceiverEndpoint": 
            case "EnableMessageLogReceiverEndpoints": {
                return BeanNameHelper.beanNameForMessageLogReceiverEndpoint(channelName);
            }
            case "EnableEventSource": 
            case "EnableEventSources": {
                return BeanNameHelper.beanNameForEventSource(channelName);
            }
            case "EnableMessageQueueReceiverEndpoint": 
            case "EnableMessageQueueReceiverEndpoints": {
                return BeanNameHelper.beanNameForMessageQueueReceiverEndpoint(channelName);
            }
            case "EnableMessageSenderEndpoint": 
            case "EnableMessageSenderEndpoints": {
                return BeanNameHelper.beanNameForMessageSenderEndpoint(channelName);
            }
        }
        throw new IllegalArgumentException("Unable to resolve bean name for " + annotationType.getName());
    }

    public static String beanNameForEventSource(String channelName) {
        return CaseFormat.LOWER_HYPHEN.to(CaseFormat.LOWER_CAMEL, channelName) + "EventSource";
    }

    public static String beanNameForMessageLogReceiverEndpoint(String channelName) {
        return CaseFormat.LOWER_HYPHEN.to(CaseFormat.LOWER_CAMEL, channelName) + "MessageLogReceiverEndpoint";
    }

    public static String beanNameForMessageQueueReceiverEndpoint(String channelName) {
        return CaseFormat.LOWER_HYPHEN.to(CaseFormat.LOWER_CAMEL, channelName) + "MessageQueueReceiverEndpoint";
    }

    public static String beanNameForMessageSenderEndpoint(String channelName) {
        return CaseFormat.LOWER_HYPHEN.to(CaseFormat.LOWER_CAMEL, channelName) + "MessageSenderEndpoint";
    }
}

