/*
 * Decompiled with CFR 0.152.
 */
package de.otto.synapse.annotation;

import com.google.common.base.Strings;
import de.otto.synapse.annotation.BeanNameHelper;
import java.lang.annotation.Annotation;
import java.lang.annotation.Repeatable;
import java.util.Objects;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.support.BeanDefinitionRegistry;
import org.springframework.context.EnvironmentAware;
import org.springframework.context.annotation.ImportBeanDefinitionRegistrar;
import org.springframework.core.annotation.AnnotationAttributes;
import org.springframework.core.env.Environment;
import org.springframework.core.type.AnnotationMetadata;

public abstract class AbstractAnnotationBasedBeanRegistrar
implements ImportBeanDefinitionRegistrar,
EnvironmentAware {
    private static final Logger LOG = LoggerFactory.getLogger(AbstractAnnotationBasedBeanRegistrar.class);
    private Environment environment;

    public final void setEnvironment(Environment environment) {
        this.environment = environment;
    }

    public final Environment getEnvironment() {
        return this.environment;
    }

    public void registerBeanDefinitions(AnnotationMetadata metadata, BeanDefinitionRegistry registry) {
        Class<? extends Annotation> repeatableAnnotationType;
        Class<? extends Annotation> annotationType = this.getAnnotationType();
        Class<? extends Annotation> clazz = repeatableAnnotationType = annotationType.isAnnotationPresent(Repeatable.class) ? annotationType.getAnnotation(Repeatable.class).value() : null;
        if (repeatableAnnotationType != null && metadata.hasAnnotation(repeatableAnnotationType.getName())) {
            AnnotationAttributes[] value;
            AnnotationAttributes annotationAttributes = (AnnotationAttributes)metadata.getAnnotationAttributes(repeatableAnnotationType.getName(), false);
            for (AnnotationAttributes attributes : value = Objects.requireNonNull(annotationAttributes).getAnnotationArray("value")) {
                this.registerBeanDefinitions(attributes, registry);
            }
        } else if (metadata.hasAnnotation(annotationType.getName())) {
            AnnotationAttributes annotationAttributes = (AnnotationAttributes)metadata.getAnnotationAttributes(annotationType.getName(), false);
            this.registerBeanDefinitions(annotationAttributes, registry);
        }
    }

    protected abstract Class<? extends Annotation> getAnnotationType();

    protected abstract void registerBeanDefinitions(String var1, String var2, AnnotationAttributes var3, BeanDefinitionRegistry var4);

    private void registerBeanDefinitions(AnnotationAttributes annotationAttributes, BeanDefinitionRegistry registry) {
        if (annotationAttributes != null) {
            String channelName = this.getChannelName(annotationAttributes);
            String beanName = this.getBeanName(annotationAttributes, channelName);
            this.registerBeanDefinitions(channelName, beanName, annotationAttributes, registry);
        }
    }

    private String getBeanName(AnnotationAttributes annotationAttributes, String channelName) {
        return Objects.toString(Strings.emptyToNull((String)annotationAttributes.getString("name")), BeanNameHelper.beanNameFor(this.getAnnotationType(), channelName));
    }

    private String getChannelName(AnnotationAttributes annotationAttributes) {
        return this.environment.resolvePlaceholders(annotationAttributes.getString("channelName"));
    }
}

