/*
 * Decompiled with CFR 0.152.
 */
package de.otto.synapse.messagestore;

import com.google.common.annotations.Beta;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import de.otto.synapse.messagestore.Index;
import de.otto.synapse.messagestore.Indexer;
import de.otto.synapse.messagestore.MessageStoreEntry;
import javax.annotation.Nonnull;

@Beta
public class CompositeIndexer
implements Indexer {
    private final ImmutableList<Indexer> indexers;
    private final ImmutableSet<Index> indexes;

    public CompositeIndexer(ImmutableList<Indexer> indexers) {
        if (indexers.size() < 2) {
            throw new IllegalArgumentException("Can not build a CompositeIndexer from less than two elements");
        }
        this.indexes = (ImmutableSet)indexers.stream().flatMap(indexer -> indexer.getIndexes().stream()).collect(ImmutableSet.toImmutableSet());
        this.indexers = indexers;
    }

    @Override
    @Nonnull
    public ImmutableSet<Index> getIndexes() {
        return this.indexes;
    }

    @Override
    public boolean supports(@Nonnull Index index) {
        return this.indexes.contains((Object)index);
    }

    @Override
    public String calc(@Nonnull Index index, @Nonnull MessageStoreEntry entry) {
        if (this.supports(index)) {
            return this.indexers.stream().filter(indexer -> indexer.supports(index)).findFirst().map(indexer -> indexer.calc(index, entry)).orElseThrow(IllegalStateException::new);
        }
        throw new IllegalArgumentException("Unknown index " + index.getName());
    }

    @Override
    @Nonnull
    public MessageStoreEntry index(@Nonnull MessageStoreEntry entry) {
        ImmutableMap.Builder filterValues = ImmutableMap.builder();
        this.getIndexes().forEach(index -> filterValues.put(index, (Object)this.calc((Index)index, entry)));
        return MessageStoreEntry.of(entry.getChannelName(), (ImmutableMap<Index, String>)filterValues.build(), entry.getTextMessage());
    }
}

