/*
 * Decompiled with CFR 0.152.
 */
package de.otto.synapse.info;

import de.otto.synapse.info.MessageReceiverEndpointInfo;
import de.otto.synapse.info.MessageReceiverStatus;
import java.util.Comparator;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.stream.Stream;

public class MessageReceiverEndpointInfos {
    private static final String MSG_CHANNEL_STARTING = "Channel is starting";
    private Map<String, MessageReceiverEndpointInfo> channelNameToEndpointInfo = new ConcurrentHashMap<String, MessageReceiverEndpointInfo>();

    public void add(String channelName) {
        this.channelNameToEndpointInfo.put(channelName, MessageReceiverEndpointInfo.builder().withChannelName(channelName).withMessage(MSG_CHANNEL_STARTING).withStatus(MessageReceiverStatus.STARTING).build());
    }

    public void update(String channelName, MessageReceiverEndpointInfo info) {
        this.channelNameToEndpointInfo.put(channelName, info);
    }

    public Stream<MessageReceiverEndpointInfo> stream() {
        return this.channelNameToEndpointInfo.values().stream().sorted(Comparator.comparing(MessageReceiverEndpointInfo::getChannelName));
    }

    public MessageReceiverEndpointInfo getChannelInfoFor(String channel) {
        if (!this.channelNameToEndpointInfo.containsKey(channel)) {
            throw new IllegalArgumentException("Unknown channel '" + channel + "'");
        }
        return this.channelNameToEndpointInfo.get(channel);
    }
}

