/*
 * Decompiled with CFR 0.152.
 */
package de.otto.synapse.eventsource;

import de.otto.synapse.channel.selector.MessageLog;
import de.otto.synapse.channel.selector.Selector;
import de.otto.synapse.endpoint.receiver.MessageLogReceiverEndpoint;
import de.otto.synapse.eventsource.DefaultEventSource;
import de.otto.synapse.eventsource.EventSource;
import de.otto.synapse.eventsource.EventSourceBuilder;
import de.otto.synapse.messagestore.MessageStore;
import de.otto.synapse.messagestore.MessageStoreFactory;

public class DefaultEventSourceBuilder
implements EventSourceBuilder {
    private final MessageStoreFactory<? extends MessageStore> snapshotMessageStoreFactory;
    private final Class<? extends MessageLog> selector;

    public DefaultEventSourceBuilder(MessageStoreFactory<? extends MessageStore> snapshotMessageStoreFactory, Class<? extends MessageLog> selector) {
        this.snapshotMessageStoreFactory = snapshotMessageStoreFactory;
        this.selector = selector;
    }

    @Override
    public EventSource buildEventSource(MessageLogReceiverEndpoint messageLogReceiverEndpoint) {
        String channelName = messageLogReceiverEndpoint.getChannelName();
        MessageStore messageStore = this.snapshotMessageStoreFactory.createMessageStoreFor(channelName);
        return new DefaultEventSource(messageStore, messageLogReceiverEndpoint);
    }

    @Override
    public Class<? extends Selector> selector() {
        return this.selector;
    }
}

