/*
 * Decompiled with CFR 0.152.
 */
package de.otto.synapse.eventsource;

import de.otto.synapse.consumer.MessageConsumer;
import de.otto.synapse.consumer.MessageDispatcher;
import de.otto.synapse.endpoint.receiver.MessageLogReceiverEndpoint;
import de.otto.synapse.eventsource.EventSource;
import java.util.concurrent.atomic.AtomicBoolean;
import javax.annotation.Nonnull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractEventSource
implements EventSource {
    private static final Logger LOG = LoggerFactory.getLogger(AbstractEventSource.class);
    private final MessageLogReceiverEndpoint messageLog;
    private final AtomicBoolean stopping = new AtomicBoolean(false);

    public AbstractEventSource(MessageLogReceiverEndpoint messageLog) {
        this.messageLog = messageLog;
    }

    @Override
    public String getChannelName() {
        return this.messageLog.getChannelName();
    }

    @Override
    public void stop() {
        LOG.info("Stopping EventSource {}", (Object)this.getChannelName());
        this.stopping.set(true);
        this.messageLog.stop();
    }

    @Override
    public boolean isStopping() {
        return this.stopping.get();
    }

    @Override
    public void register(MessageConsumer<?> messageConsumer) {
        this.messageLog.register(messageConsumer);
    }

    @Override
    @Nonnull
    public MessageDispatcher getMessageDispatcher() {
        return this.messageLog.getMessageDispatcher();
    }

    @Override
    @Nonnull
    public MessageLogReceiverEndpoint getMessageLogReceiverEndpoint() {
        return this.messageLog;
    }
}

