/*
 * Decompiled with CFR 0.152.
 */
package de.otto.synapse.endpoint.sender;

import de.otto.synapse.endpoint.AbstractMessageEndpoint;
import de.otto.synapse.endpoint.EndpointType;
import de.otto.synapse.endpoint.MessageInterceptorRegistry;
import de.otto.synapse.endpoint.sender.MessageSenderEndpoint;
import de.otto.synapse.message.Message;
import de.otto.synapse.message.TextMessage;
import de.otto.synapse.translator.MessageFormat;
import de.otto.synapse.translator.MessageTranslator;
import java.util.Objects;
import java.util.concurrent.CompletableFuture;
import java.util.stream.Stream;
import javax.annotation.Nonnull;

public abstract class AbstractMessageSenderEndpoint
extends AbstractMessageEndpoint
implements MessageSenderEndpoint {
    public static final int BATCH_SENDER_TIMEOUT = 500;
    private final MessageTranslator<TextMessage> messageTranslator;

    public AbstractMessageSenderEndpoint(@Nonnull String channelName, @Nonnull MessageInterceptorRegistry interceptorRegistry, @Nonnull MessageTranslator<TextMessage> messageTranslator) {
        super(channelName, interceptorRegistry);
        this.messageTranslator = messageTranslator;
    }

    @Override
    public final CompletableFuture<Void> send(@Nonnull Message<?> message) {
        TextMessage translatedMessage = this.messageTranslator.apply(message);
        TextMessage interceptedMessage = this.intercept(translatedMessage);
        if (interceptedMessage != null) {
            return this.doSend(interceptedMessage);
        }
        return CompletableFuture.completedFuture(null);
    }

    @Override
    public final CompletableFuture<Void> sendBatch(@Nonnull Stream<? extends Message<?>> batch) {
        return this.doSendBatch(batch.map(this.messageTranslator::apply).map(this::intercept).filter(Objects::nonNull));
    }

    @Override
    @Nonnull
    public final EndpointType getEndpointType() {
        return EndpointType.SENDER;
    }

    protected CompletableFuture<Void> doSendBatch(@Nonnull Stream<TextMessage> batch) {
        return CompletableFuture.allOf((CompletableFuture[])batch.map(this::doSend).toArray(CompletableFuture[]::new));
    }

    protected abstract CompletableFuture<Void> doSend(@Nonnull TextMessage var1);

    public MessageFormat getMessageFormat() {
        return MessageFormat.defaultMessageFormat();
    }
}

