/*
 * Decompiled with CFR 0.152.
 */
package de.otto.synapse.endpoint.receiver;

import de.otto.synapse.channel.ChannelPosition;
import de.otto.synapse.endpoint.receiver.MessageLogReceiverEndpoint;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.context.ApplicationContext;
import org.springframework.context.SmartLifecycle;

public class MessageLogConsumerContainer
implements SmartLifecycle {
    private static final Logger LOG = LoggerFactory.getLogger(MessageLogConsumerContainer.class);
    private final MessageLogReceiverEndpoint endpoint;
    private final ChannelPosition startFrom;
    private volatile boolean running = false;

    public MessageLogConsumerContainer(String messageLogBeanName, ChannelPosition startFrom, ApplicationContext applicationContext) {
        this.endpoint = (MessageLogReceiverEndpoint)applicationContext.getBean(messageLogBeanName, MessageLogReceiverEndpoint.class);
        this.startFrom = startFrom;
    }

    public boolean isAutoStartup() {
        return true;
    }

    public void stop(Runnable callback) {
        this.stop();
        callback.run();
    }

    public int getPhase() {
        return 0;
    }

    public void start() {
        LOG.info("Initializing MessageLogConsumerContainer with {} message logs", (Object)this.endpoint.getChannelName());
        this.running = true;
        try {
            LOG.info("Starting message log {}...", (Object)this.endpoint.getChannelName());
            this.endpoint.consume(this.startFrom);
        }
        catch (Exception e) {
            LOG.error("Starting message log failed: " + e.getMessage(), (Throwable)e);
            this.stop();
        }
    }

    public void stop() {
        LOG.info("Shutting down...");
        this.endpoint.stop();
        this.running = false;
        LOG.info("...done.");
    }

    public boolean isRunning() {
        return this.running;
    }
}

