/*
 * Decompiled with CFR 0.152.
 */
package de.otto.synapse.endpoint.receiver;

import de.otto.synapse.channel.ChannelPosition;
import de.otto.synapse.channel.ShardResponse;
import de.otto.synapse.channel.selector.Selector;
import de.otto.synapse.consumer.MessageConsumer;
import de.otto.synapse.consumer.MessageDispatcher;
import de.otto.synapse.endpoint.BestMatchingSelectableComparator;
import de.otto.synapse.endpoint.EndpointType;
import de.otto.synapse.endpoint.InterceptorChain;
import de.otto.synapse.endpoint.receiver.MessageLogReceiverEndpoint;
import de.otto.synapse.endpoint.receiver.MessageLogReceiverEndpointFactory;
import de.otto.synapse.message.TextMessage;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import java.util.function.Predicate;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

public class DelegateMessageLogReceiverEndpoint
implements MessageLogReceiverEndpoint {
    private final MessageLogReceiverEndpoint delegate;

    public DelegateMessageLogReceiverEndpoint(@Nonnull String channelName, @Nonnull Class<? extends Selector> selector, @Nonnull List<MessageLogReceiverEndpointFactory> factories) {
        MessageLogReceiverEndpointFactory selectedEndpointFactory = factories.stream().filter(factory -> factory.matches(selector)).min(new BestMatchingSelectableComparator(selector)).orElseThrow(() -> new IllegalStateException(String.format("Unable to create MessageLogReceiverEndpoint for channelName=%s: no matching MessageLogReceiverEndpointFactory found in the ApplicationContext.", channelName)));
        this.delegate = selectedEndpointFactory.create(channelName);
    }

    @Override
    @Nonnull
    public CompletableFuture<ChannelPosition> consumeUntil(@Nonnull ChannelPosition startFrom, @Nonnull Predicate<ShardResponse> stopCondition) {
        return this.delegate.consumeUntil(startFrom, stopCondition);
    }

    @Override
    public void stop() {
        this.delegate.stop();
    }

    @Override
    public void register(MessageConsumer<?> messageConsumer) {
        this.delegate.register(messageConsumer);
    }

    @Override
    @Nonnull
    public MessageDispatcher getMessageDispatcher() {
        return this.delegate.getMessageDispatcher();
    }

    @Override
    @Nonnull
    public String getChannelName() {
        return this.delegate.getChannelName();
    }

    @Override
    @Nonnull
    public InterceptorChain getInterceptorChain() {
        return this.delegate.getInterceptorChain();
    }

    @Override
    @Nonnull
    public EndpointType getEndpointType() {
        return this.delegate.getEndpointType();
    }

    @Override
    @Nullable
    public TextMessage intercept(@Nonnull TextMessage message) {
        return this.delegate.intercept(message);
    }

    public MessageLogReceiverEndpoint getDelegate() {
        return this.delegate;
    }
}

