/*
 * Decompiled with CFR 0.152.
 */
package de.otto.synapse.endpoint;

import de.otto.synapse.endpoint.MessageInterceptor;
import de.otto.synapse.message.Message;
import de.otto.synapse.message.TextMessage;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.util.Arrays;
import java.util.Objects;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

public class MethodInvokingMessageInterceptor
implements MessageInterceptor {
    private final Object instance;
    private final Method method;
    private final boolean returnsMessage;

    public MethodInvokingMessageInterceptor(Object instance, Method method) {
        Objects.requireNonNull(instance, "Unable to build MethodInvokingMessageInterceptor: instance parameter is null");
        Objects.requireNonNull(method, "Unable to build MethodInvokingMessageInterceptor: method parameter is null");
        if (method.getReturnType() != Void.TYPE && !Message.class.isAssignableFrom(method.getReturnType())) {
            throw new IllegalArgumentException("Unable to build MethodInvokingMessageInterceptor: return type of the annotated method must be void or Message<String> or TextMessage");
        }
        if (method.getParameterCount() != 1) {
            throw new IllegalArgumentException("Unable to build MethodInvokingMessageInterceptor: illegal number of arguments, expected exactly one parameter with type Message<String> or TextMessage");
        }
        this.assertIsMessageWithStringTypeParam(method.getGenericReturnType());
        this.assertIsMessageOrVoid(method.getReturnType());
        this.assertIsMessageWithStringTypeParam(method.getGenericParameterTypes()[0]);
        this.assertIsMessage(method.getParameterTypes()[0]);
        this.method = method;
        this.instance = instance;
        this.returnsMessage = method.getReturnType() != Void.class && method.getReturnType() != Void.TYPE;
    }

    private void assertIsMessageWithStringTypeParam(Type type) {
        if (type instanceof ParameterizedType) {
            boolean hasStringArgument;
            ParameterizedType parameterizedType = (ParameterizedType)type;
            boolean isMessageType = !parameterizedType.getRawType().equals(Message.class);
            boolean bl = hasStringArgument = !Arrays.equals(parameterizedType.getActualTypeArguments(), new Type[]{String.class});
            if (isMessageType || hasStringArgument) {
                throw new IllegalArgumentException("Unable to build MethodInvokingMessageInterceptor: parameter " + type);
            }
        }
    }

    private void assertIsMessage(Class<?> paramType) {
        if (!Message.class.isAssignableFrom(paramType)) {
            throw new IllegalArgumentException("Unable to build MethodInvokingMessageInterceptor: expected parameter type is Message, not " + paramType.getName());
        }
    }

    private void assertIsMessageOrVoid(Class<?> paramType) {
        if (!(Message.class.isAssignableFrom(paramType) || paramType.equals(Void.TYPE) || paramType.equals(Void.class))) {
            throw new IllegalArgumentException("Unable to build MethodInvokingMessageInterceptor: expected parameter type is Message, not " + paramType.getName());
        }
    }

    @Override
    @Nullable
    public TextMessage intercept(@Nonnull TextMessage message) {
        try {
            if (this.returnsMessage) {
                Message interceptedMessage = (Message)this.method.invoke(this.instance, message);
                if (interceptedMessage == null || interceptedMessage == message || interceptedMessage instanceof TextMessage) {
                    return (TextMessage)interceptedMessage;
                }
                return TextMessage.of(interceptedMessage);
            }
            this.method.invoke(this.instance, message);
            return message;
        }
        catch (IllegalAccessException | InvocationTargetException e) {
            throw new IllegalStateException(e);
        }
    }
}

