/*
 * Decompiled with CFR 0.152.
 */
package de.otto.synapse.consumer;

import de.otto.synapse.consumer.MessageConsumer;
import de.otto.synapse.message.Message;
import de.otto.synapse.message.TextMessage;
import de.otto.synapse.translator.ObjectMappers;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.function.Consumer;
import java.util.regex.Pattern;
import javax.annotation.Nonnull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MessageDispatcher
implements Consumer<TextMessage> {
    private static final Logger LOG = LoggerFactory.getLogger(MessageDispatcher.class);
    private static final Pattern ACCEPT_ALL = Pattern.compile(".*");
    private final List<MessageConsumer<?>> messageConsumers;

    public MessageDispatcher() {
        this.messageConsumers = Collections.synchronizedList(new ArrayList());
    }

    public MessageDispatcher(List<MessageConsumer<?>> messageConsumers) {
        this.messageConsumers = Collections.synchronizedList(new ArrayList(messageConsumers));
    }

    public void add(MessageConsumer<?> messageConsumer) {
        this.messageConsumers.add(messageConsumer);
    }

    public List<MessageConsumer<?>> getAll() {
        return Collections.unmodifiableList(this.messageConsumers);
    }

    @Nonnull
    public Class<String> payloadType() {
        return String.class;
    }

    @Nonnull
    public Pattern keyPattern() {
        return ACCEPT_ALL;
    }

    @Override
    public void accept(TextMessage message) {
        LOG.debug("Accepting message={}", (Object)message);
        this.messageConsumers.stream().filter(consumer -> this.matchesKeyPattern(message, consumer.keyPattern())).forEach(consumer -> {
            try {
                Class payloadType = consumer.payloadType();
                if (payloadType.equals(String.class)) {
                    consumer.accept(message);
                } else {
                    Object payload = null;
                    if (message.getPayload() != null) {
                        payload = ObjectMappers.currentObjectMapper().readValue((String)message.getPayload(), payloadType);
                    }
                    Message<Object> tMessage = Message.message(message.getKey(), message.getHeader(), payload);
                    consumer.accept(tMessage);
                }
            }
            catch (Exception e) {
                LOG.error(e.getMessage(), (Throwable)e);
                throw new IllegalStateException(e.getMessage(), e);
            }
        });
    }

    private boolean matchesKeyPattern(TextMessage message, Pattern keyPattern) {
        return keyPattern.matcher(message.getKey().compactionKey()).matches();
    }
}

