/*
 * Decompiled with CFR 0.152.
 */
package de.otto.synapse.configuration;

import de.otto.synapse.annotation.EventSourceConsumerBeanPostProcessor;
import de.otto.synapse.channel.selector.MessageLog;
import de.otto.synapse.configuration.SynapseAutoConfiguration;
import de.otto.synapse.configuration.SynapseProperties;
import de.otto.synapse.eventsource.DefaultEventSourceBuilder;
import de.otto.synapse.eventsource.EventSource;
import de.otto.synapse.eventsource.EventSourceBuilder;
import de.otto.synapse.eventsource.EventSourceConsumerProcess;
import de.otto.synapse.messagestore.MessageStoreFactory;
import de.otto.synapse.messagestore.MessageStores;
import de.otto.synapse.messagestore.SnapshotMessageStore;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.autoconfigure.condition.ConditionalOnBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.Import;
import org.springframework.context.annotation.Role;

@Configuration
@Import(value={SynapseAutoConfiguration.class})
@EnableConfigurationProperties(value={SynapseProperties.class})
public class EventSourcingAutoConfiguration {
    private static final Logger LOG = LoggerFactory.getLogger(EventSourcingAutoConfiguration.class);

    @Bean
    @ConditionalOnMissingBean(name={"defaultEventSourceBuilder"})
    @ConditionalOnBean(name={"snapshotMessageStoreFactory"})
    public EventSourceBuilder defaultEventSourceBuilder(MessageStoreFactory<SnapshotMessageStore> snapshotMessageStoreFactory) {
        return new DefaultEventSourceBuilder(snapshotMessageStoreFactory, MessageLog.class);
    }

    @Bean
    @ConditionalOnMissingBean(name={"defaultEventSourceBuilder", "snapshotMessageStoreFactory"})
    public EventSourceBuilder fallbackEventSourceBuilder() {
        LOG.info("No MessageStoreFactory is configured. Falling back to EventStoreBuilder w/o Snapshot MessageStore");
        return new DefaultEventSourceBuilder(_x -> MessageStores.emptyMessageStore(), MessageLog.class);
    }

    @Bean
    @ConditionalOnProperty(prefix="synapse", name={"consumer-process.enabled"}, havingValue="true", matchIfMissing=true)
    public EventSourceConsumerProcess eventSourceConsumerProcess(@Autowired(required=false) List<EventSource> eventSources) {
        return new EventSourceConsumerProcess(eventSources);
    }

    @Bean
    @Role(value=2)
    public EventSourceConsumerBeanPostProcessor eventSourceConsumerAnnotationBeanPostProcessor() {
        return new EventSourceConsumerBeanPostProcessor();
    }
}

