/*
 * Decompiled with CFR 0.152.
 */
package de.otto.synapse.annotation;

import de.otto.synapse.annotation.MessageLogConsumer;
import de.otto.synapse.consumer.MethodInvokingMessageConsumer;
import de.otto.synapse.endpoint.receiver.MessageLogReceiverEndpoint;
import de.otto.synapse.endpoint.receiver.MessageReceiverEndpoint;
import java.lang.reflect.Method;
import java.util.Collections;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.aop.support.AopUtils;
import org.springframework.beans.BeansException;
import org.springframework.beans.factory.config.BeanPostProcessor;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ApplicationContextAware;
import org.springframework.context.ConfigurableApplicationContext;
import org.springframework.core.MethodIntrospector;
import org.springframework.core.Ordered;
import org.springframework.core.annotation.AnnotationUtils;

public class MessageLogConsumerBeanPostProcessor
implements BeanPostProcessor,
Ordered,
ApplicationContextAware {
    private static final Logger LOG = LoggerFactory.getLogger(MessageLogConsumerBeanPostProcessor.class);
    private final Set<Class<?>> nonAnnotatedClasses = Collections.newSetFromMap(new ConcurrentHashMap(64));
    private ConfigurableApplicationContext applicationContext;

    public int getOrder() {
        return Integer.MAX_VALUE;
    }

    public void setApplicationContext(ApplicationContext applicationContext) throws BeansException {
        if (applicationContext instanceof ConfigurableApplicationContext) {
            this.applicationContext = (ConfigurableApplicationContext)applicationContext;
        }
    }

    public Object postProcessBeforeInitialization(Object bean, String beanName) {
        return bean;
    }

    public Object postProcessAfterInitialization(Object bean, String beanName) {
        if (!this.nonAnnotatedClasses.contains(bean.getClass())) {
            Class targetClass = AopUtils.getTargetClass((Object)bean);
            Map<Method, Set<MessageLogConsumer>> annotatedMethods = this.findMethodsAnnotatedWithMessageLogConsumer(targetClass);
            if (annotatedMethods.isEmpty()) {
                this.nonAnnotatedClasses.add(bean.getClass());
                LOG.trace("No @MessageLogConsumer annotations found on bean type: {}", bean.getClass());
            } else {
                this.registerMessageLogConsumers(bean, beanName, annotatedMethods);
            }
        }
        return bean;
    }

    private Map<Method, Set<MessageLogConsumer>> findMethodsAnnotatedWithMessageLogConsumer(Class<?> targetClass) {
        return MethodIntrospector.selectMethods(targetClass, method -> {
            Set<MessageLogConsumer> consumerAnnotations = this.consumerAnnotationsOf(method);
            return !consumerAnnotations.isEmpty() ? consumerAnnotations : null;
        });
    }

    private void registerMessageLogConsumers(Object bean, String beanName, Map<Method, Set<MessageLogConsumer>> annotatedMethods) {
        for (Map.Entry<Method, Set<MessageLogConsumer>> entry : annotatedMethods.entrySet()) {
            Method method = entry.getKey();
            for (MessageLogConsumer consumerAnnotation : entry.getValue()) {
                this.matchingMessageLogReceiverEndpointFor(consumerAnnotation).register(this.MessageLogConsumerFor(consumerAnnotation, method, bean));
            }
        }
        LOG.info("{} @MessageLogConsumer methods processed on bean {} : {}'", new Object[]{annotatedMethods.size(), beanName, annotatedMethods});
    }

    private Set<MessageLogConsumer> consumerAnnotationsOf(Method method) {
        HashSet<MessageLogConsumer> listeners = new HashSet<MessageLogConsumer>();
        MessageLogConsumer ann = (MessageLogConsumer)AnnotationUtils.findAnnotation((Method)method, MessageLogConsumer.class);
        if (ann != null) {
            listeners.add(ann);
        }
        return listeners;
    }

    private MethodInvokingMessageConsumer<?> MessageLogConsumerFor(MessageLogConsumer annotation, Method annotatedMethod, Object bean) {
        return new MethodInvokingMessageConsumer(annotation.keyPattern(), annotation.payloadType(), bean, annotatedMethod);
    }

    private MessageReceiverEndpoint matchingMessageLogReceiverEndpointFor(MessageLogConsumer annotation) {
        return (MessageReceiverEndpoint)this.applicationContext.getBean(annotation.endpointName(), MessageLogReceiverEndpoint.class);
    }
}

