/*
 * Decompiled with CFR 0.152.
 */
package de.otto.synapse.translator;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.JsonNode;
import de.otto.synapse.message.Header;
import de.otto.synapse.message.Message;
import de.otto.synapse.translator.MessageFormat;
import de.otto.synapse.translator.ObjectMappers;
import java.io.IOException;
import java.util.Collections;
import java.util.Map;
import java.util.regex.Pattern;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MessageCodec {
    public static final String SYNAPSE_MSG_FORMAT = "_synapse_msg_format";
    public static final String SYNAPSE_MSG_HEADERS = "_synapse_msg_headers";
    public static final String SYNAPSE_MSG_PAYLOAD = "_synapse_msg_payload";
    public static final Pattern V2_PATTERN = Pattern.compile("\\{\\s*\"_synapse_msg_format\"\\s*:\\s*\"v2\".+");
    private static final Logger LOG = LoggerFactory.getLogger(MessageCodec.class);
    private static final TypeReference<Map<String, String>> MAP_TYPE_REFERENCE = new TypeReference<Map<String, String>>(){};

    public static String encode(Message<String> message) {
        return MessageCodec.encode(message, MessageFormat.defaultMessageFormat());
    }

    public static String encode(Message<String> message, MessageFormat messageFormat) {
        switch (messageFormat) {
            case V1: {
                return message.getPayload();
            }
            case V2: {
                return MessageCodec.encodeV2(message);
            }
        }
        throw new IllegalStateException("Unsupported MessageFormat " + (Object)((Object)messageFormat));
    }

    private static String encodeV2(Message<String> message) {
        String jsonHeaders;
        String jsonPayload;
        if (message.getPayload() == null) {
            jsonPayload = null;
        } else if (message.getPayload().isEmpty()) {
            jsonPayload = "\"\"";
        } else {
            String trimedPayload = message.getPayload().trim();
            if (trimedPayload.startsWith("{") && trimedPayload.endsWith("}") || trimedPayload.startsWith("[") && trimedPayload.endsWith("]")) {
                jsonPayload = trimedPayload;
            } else {
                try {
                    jsonPayload = ObjectMappers.defaultObjectMapper().writeValueAsString((Object)message.getPayload());
                }
                catch (JsonProcessingException e) {
                    throw new IllegalArgumentException("Unable to generate message payload from " + message.getPayload() + ": " + e.getMessage(), e);
                }
            }
        }
        try {
            jsonHeaders = ObjectMappers.defaultObjectMapper().writeValueAsString(message.getHeader().getAttributes());
        }
        catch (JsonProcessingException e) {
            LOG.error("Failed to convert message headers={} into JSON message format v2: {}", (Object)message.getHeader(), (Object)e.getMessage());
            jsonHeaders = "{}";
        }
        return "{\"_synapse_msg_format\":\"v2\",\"_synapse_msg_headers\":" + jsonHeaders + ",\"_synapse_msg_payload\":" + jsonPayload + "}";
    }

    public static Message<String> decode(String body, Header.Builder headerBuilder, Message.Builder<String> messageBuilder) {
        switch (MessageCodec.versionOf(body)) {
            case V1: {
                return messageBuilder.withHeader(headerBuilder.build()).withPayload(body).build();
            }
            case V2: {
                try {
                    JsonNode json = MessageCodec.parseRecordBody(body);
                    return messageBuilder.withHeader(headerBuilder.withAttributes(MessageCodec.attributesFrom(json)).build()).withPayload(MessageCodec.payloadFrom(json)).build();
                }
                catch (RuntimeException e) {
                    return messageBuilder.withHeader(headerBuilder.build()).withPayload(body).build();
                }
            }
        }
        throw new IllegalStateException("Unsupported message format: " + body);
    }

    private static MessageFormat versionOf(String body) {
        if (body != null) {
            return V2_PATTERN.matcher(body).matches() ? MessageFormat.V2 : MessageFormat.V1;
        }
        return MessageFormat.V1;
    }

    private static Map<String, String> attributesFrom(JsonNode json) {
        JsonNode headersJson = json.get(SYNAPSE_MSG_HEADERS);
        if (headersJson != null) {
            return (Map)ObjectMappers.defaultObjectMapper().convertValue((Object)headersJson, MAP_TYPE_REFERENCE);
        }
        return Collections.emptyMap();
    }

    private static String payloadFrom(JsonNode json) {
        JsonNode payloadJson = json.get(SYNAPSE_MSG_PAYLOAD);
        if (payloadJson == null || payloadJson.isNull()) {
            return null;
        }
        if (payloadJson.isObject() || payloadJson.isArray()) {
            return payloadJson.toString();
        }
        String msg = "Unexpected json node containing " + json + ": ";
        LOG.error(msg);
        throw new IllegalStateException(msg);
    }

    private static JsonNode parseRecordBody(String body) {
        try {
            return ObjectMappers.defaultObjectMapper().readTree(body);
        }
        catch (IOException e) {
            LOG.error("Error parsing body={} from Kinesis record: {}", (Object)body, (Object)e.getMessage());
            throw new IllegalStateException(e.getMessage(), e);
        }
    }
}

