/*
 * Decompiled with CFR 0.152.
 */
package de.otto.synapse.translator;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import de.otto.synapse.message.Message;
import de.otto.synapse.message.Messages;
import de.otto.synapse.translator.MessageTranslator;
import de.otto.synapse.translator.ObjectMappers;
import java.nio.ByteBuffer;
import javax.annotation.Nonnull;

public class JsonByteBufferMessageTranslator
implements MessageTranslator<ByteBuffer> {
    private final ObjectMapper objectMapper;

    public JsonByteBufferMessageTranslator() {
        this.objectMapper = ObjectMappers.defaultObjectMapper();
    }

    public JsonByteBufferMessageTranslator(@Nonnull ObjectMapper objectMapper) {
        this.objectMapper = objectMapper;
    }

    @Override
    @Nonnull
    public Message<ByteBuffer> translate(@Nonnull Message<?> message) {
        if (message.getPayload() == null) {
            return Messages.byteBufferMessage(message.getKey(), message.getHeader(), (ByteBuffer)null);
        }
        try {
            byte[] payload = this.objectMapper.writeValueAsBytes(message.getPayload());
            return Messages.byteBufferMessage(message.getKey(), message.getHeader(), ByteBuffer.wrap(payload));
        }
        catch (JsonProcessingException e) {
            throw new IllegalStateException(e.getMessage());
        }
    }
}

