/*
 * Decompiled with CFR 0.152.
 */
package de.otto.synapse.message;

import de.otto.synapse.message.Header;
import java.io.Serializable;
import java.util.Objects;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

public class Message<T>
implements Serializable {
    private final String key;
    private final Header header;
    private final T payload;

    public static <T> Message<T> message(@Nonnull String key, @Nullable T payload) {
        return new Message<T>(key, Header.emptyHeader(), payload);
    }

    public static <T> Message<T> message(@Nonnull String key, @Nonnull Header header, @Nullable T payload) {
        return new Message<T>(key, header, payload);
    }

    protected Message(@Nonnull String key, @Nonnull Header header, @Nullable T payload) {
        this.key = key;
        this.payload = payload;
        this.header = header;
    }

    @Nonnull
    public String getKey() {
        return this.key;
    }

    @Nullable
    public T getPayload() {
        return this.payload;
    }

    @Nonnull
    public Header getHeader() {
        return this.header;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Message message = (Message)o;
        return Objects.equals(this.key, message.key) && Objects.equals(this.payload, message.payload) && Objects.equals(this.header, message.header);
    }

    public int hashCode() {
        return Objects.hash(this.key, this.payload, this.header);
    }

    public String toString() {
        return "Message{key='" + this.key + '\'' + ", payload=" + this.payload + ", header=" + this.header + '}';
    }

    public static <T> Builder<T> builder(Class<T> payloadType) {
        return new Builder();
    }

    public static <T> Builder<T> copyOf(Message<T> message) {
        return new Builder().withKey(message.getKey()).withHeader(message.getHeader()).withPayload(message.getPayload());
    }

    public static class Builder<T> {
        private String key;
        private Header header;
        private T payload;

        public Builder<T> withKey(String key) {
            this.key = key;
            return this;
        }

        public Builder<T> withHeader(Header header) {
            this.header = header;
            return this;
        }

        public Builder<T> withPayload(T payload) {
            this.payload = payload;
            return this;
        }

        public Message<T> build() {
            return new Message<T>(this.key, this.header, this.payload);
        }
    }
}

