/*
 * Decompiled with CFR 0.152.
 */
package de.otto.synapse.info;

import de.otto.synapse.channel.ChannelDurationBehind;
import de.otto.synapse.info.MessageReceiverStatus;
import java.util.Objects;
import java.util.Optional;

public class MessageReceiverEndpointInfo {
    private final String channelName;
    private final String message;
    private final MessageReceiverStatus status;
    private final Optional<ChannelDurationBehind> durationBehind;

    private MessageReceiverEndpointInfo(Builder builder) {
        this.message = Objects.requireNonNull(builder.message);
        this.status = Objects.requireNonNull(builder.status);
        this.channelName = Objects.requireNonNull(builder.channelName);
        this.durationBehind = Optional.ofNullable(builder.channelDurationBehind);
    }

    public static Builder builder() {
        return new Builder();
    }

    public String getChannelName() {
        return this.channelName;
    }

    public String getMessage() {
        return this.message;
    }

    public MessageReceiverStatus getStatus() {
        return this.status;
    }

    public Optional<ChannelDurationBehind> getDurationBehind() {
        return this.durationBehind;
    }

    public String toString() {
        return "MessageReceiverEndpointInfo{channelName='" + this.channelName + '\'' + ", message='" + this.message + '\'' + ", status=" + (Object)((Object)this.status) + ", durationBehind=" + this.durationBehind + '}';
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        MessageReceiverEndpointInfo that = (MessageReceiverEndpointInfo)o;
        return Objects.equals(this.channelName, that.channelName) && Objects.equals(this.message, that.message) && this.status == that.status && Objects.equals(this.durationBehind, that.durationBehind);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.channelName, this.message, this.status, this.durationBehind});
    }

    public static Builder builder(MessageReceiverEndpointInfo info) {
        return new Builder().withMessage(info.message).withStatus(info.status).withChannelName(info.channelName);
    }

    public static final class Builder {
        private String channelName;
        private String message;
        private MessageReceiverStatus status;
        private ChannelDurationBehind channelDurationBehind;

        private Builder() {
        }

        public Builder withMessage(String message) {
            this.message = message;
            return this;
        }

        public Builder withStatus(MessageReceiverStatus status) {
            this.status = status;
            return this;
        }

        public Builder withChannelName(String channelName) {
            this.channelName = channelName;
            return this;
        }

        public Builder withChannelDurationBehind(ChannelDurationBehind durationBehind) {
            this.channelDurationBehind = durationBehind;
            return this;
        }

        public MessageReceiverEndpointInfo build() {
            return new MessageReceiverEndpointInfo(this);
        }
    }
}

