/*
 * Decompiled with CFR 0.152.
 */
package de.otto.synapse.endpoint;

import com.google.common.collect.ImmutableMap;
import de.otto.synapse.annotation.MessageInterceptor;
import de.otto.synapse.configuration.SynapseProperties;
import de.otto.synapse.endpoint.EndpointType;
import de.otto.synapse.message.Header;
import de.otto.synapse.message.Message;
import java.time.Clock;
import java.util.EnumSet;
import java.util.Set;
import java.util.UUID;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

public class DefaultSenderHeadersInterceptor {
    public static final String MSG_SENDER_ATTR = "synapse_msg_sender";
    public static final String MSG_ID_ATTR = "synapse_msg_id";
    public static final String MSG_TIMESTAMP_ATTR = "synapse_msg_timestamp";
    private final Set<Capability> capabilities;
    private final String senderName;
    private final Clock clock;

    public DefaultSenderHeadersInterceptor(SynapseProperties synapseProperties) {
        this.senderName = synapseProperties.getSender().getName();
        this.capabilities = EnumSet.allOf(Capability.class);
        this.clock = Clock.systemDefaultZone();
    }

    public DefaultSenderHeadersInterceptor(SynapseProperties.Sender senderProperties, Set<Capability> capabilities, Clock clock) {
        this.senderName = senderProperties.getName();
        this.capabilities = capabilities;
        this.clock = clock;
    }

    @Nullable
    @MessageInterceptor(endpointType={EndpointType.SENDER})
    public Message<String> addDefaultHeaders(@Nonnull Message<String> message) {
        ImmutableMap.Builder attributes = ImmutableMap.builder();
        if (this.capabilities.contains((Object)Capability.SENDER_NAME)) {
            attributes.put((Object)MSG_SENDER_ATTR, (Object)this.senderName);
        }
        if (this.capabilities.contains((Object)Capability.MESSAGE_ID)) {
            attributes.put((Object)MSG_ID_ATTR, (Object)UUID.randomUUID().toString());
        }
        if (this.capabilities.contains((Object)Capability.TIMESTAMP)) {
            attributes.put((Object)MSG_TIMESTAMP_ATTR, (Object)this.clock.instant().toString());
        }
        attributes.putAll(message.getHeader().getAttributes());
        return Message.message(message.getKey(), Header.requestHeader((ImmutableMap<String, String>)attributes.build()), message.getPayload());
    }

    public static enum Capability {
        SENDER_NAME,
        MESSAGE_ID,
        TIMESTAMP;

    }
}

