/*
 * Decompiled with CFR 0.152.
 */
package de.otto.synapse.consumer;

import de.otto.synapse.message.Message;
import java.util.function.Consumer;
import java.util.regex.Pattern;
import javax.annotation.Nonnull;
import javax.annotation.concurrent.ThreadSafe;

@ThreadSafe
public interface MessageConsumer<T>
extends Consumer<Message<T>> {
    public static <T> MessageConsumer<T> of(final String keyPattern, final Class<T> payloadType, final Consumer<Message<T>> consumer) {
        return new MessageConsumer<T>(){
            private Pattern pattern;
            {
                this.pattern = Pattern.compile(keyPattern);
            }

            @Override
            @Nonnull
            public Class<T> payloadType() {
                return payloadType;
            }

            @Override
            @Nonnull
            public Pattern keyPattern() {
                return this.pattern;
            }

            @Override
            public void accept(Message<T> tMessage) {
                consumer.accept(tMessage);
            }
        };
    }

    @Nonnull
    public Class<T> payloadType();

    @Nonnull
    public Pattern keyPattern();
}

