/*
 * Decompiled with CFR 0.152.
 */
package de.otto.synapse.configuration;

import org.springframework.beans.factory.annotation.Value;
import org.springframework.boot.context.properties.ConfigurationProperties;

@ConfigurationProperties(prefix="synapse")
public class SynapseProperties {
    private final ConsumerProcess consumerProcess = new ConsumerProcess();
    private final Sender sender;

    public SynapseProperties(@Value(value="${spring.application.name:Synapse}") String defaultName) {
        this.sender = new Sender(defaultName);
    }

    public ConsumerProcess getConsumerProcess() {
        return this.consumerProcess;
    }

    public Sender getSender() {
        return this.sender;
    }

    public static class ConsumerProcess {
        private boolean enabled = true;

        public boolean isEnabled() {
            return this.enabled;
        }

        public void setEnabled(boolean enabled) {
            this.enabled = enabled;
        }
    }

    public static class Sender {
        private String name;
        private final DefaultHeaders defaultHeaders = new DefaultHeaders();

        private Sender(String defaultName) {
            this.name = defaultName;
        }

        public String getName() {
            return this.name;
        }

        public void setName(String name) {
            this.name = name;
        }

        public DefaultHeaders getDefaultHeaders() {
            return this.defaultHeaders;
        }

        public class DefaultHeaders {
            private boolean enabled = true;

            public boolean isEnabled() {
                return this.enabled;
            }

            public void setEnabled(boolean enabled) {
                this.enabled = enabled;
            }
        }
    }
}

