/*
 * Decompiled with CFR 0.152.
 */
package de.otto.kafka.messaging.e2ee.vault;

import de.otto.kafka.messaging.e2ee.vault.RenewableVault;
import de.otto.kafka.messaging.e2ee.vault.VaultConnectionConfig;
import de.otto.kafka.messaging.e2ee.vault.VaultEncryptionKeyProviderConfig;
import de.otto.kafka.messaging.e2ee.vault.VaultRuntimeException;
import io.github.jopenlibs.vault.VaultException;
import java.util.Objects;

public final class SingleTopicVaultEncryptionKeyProviderConfig
implements VaultEncryptionKeyProviderConfig {
    private final boolean isEncryptedTopic;
    private final String kafkaTopicName;
    private final VaultConnectionConfig vaultConnectionConfig;
    private final String vaultPath;
    private final String encryptionKeyAttributeName;

    public SingleTopicVaultEncryptionKeyProviderConfig(boolean isEncryptedTopic, String kafkaTopicName, VaultConnectionConfig vaultConnectionConfig, String vaultPath) {
        this(isEncryptedTopic, kafkaTopicName, vaultConnectionConfig, vaultPath, "encryption_key");
    }

    public SingleTopicVaultEncryptionKeyProviderConfig(boolean isEncryptedTopic, String kafkaTopicName, VaultConnectionConfig vaultConnectionConfig, String vaultPath, String encryptionKeyAttributeName) {
        if (isEncryptedTopic) {
            Objects.requireNonNull(vaultConnectionConfig, "vaultConnectionConfig is required");
            Objects.requireNonNull(vaultPath, "vaultPath is required");
        }
        this.isEncryptedTopic = isEncryptedTopic;
        this.kafkaTopicName = kafkaTopicName;
        this.vaultConnectionConfig = vaultConnectionConfig;
        this.vaultPath = vaultPath;
        this.encryptionKeyAttributeName = encryptionKeyAttributeName;
    }

    public static SingleTopicVaultEncryptionKeyProviderConfigBuilder builder() {
        return new SingleTopicVaultEncryptionKeyProviderConfigBuilder();
    }

    @Override
    public RenewableVault createReadonlyVault() {
        try {
            return this.vaultConnectionConfig.createRenewableVault();
        }
        catch (VaultException e) {
            throw new VaultRuntimeException((Exception)((Object)e));
        }
    }

    @Override
    public boolean isEncryptedTopic(String kafkaTopicName) {
        if (this.kafkaTopicName == null) {
            return this.isEncryptedTopic;
        }
        if (Objects.equals(this.kafkaTopicName, kafkaTopicName)) {
            return this.isEncryptedTopic;
        }
        return false;
    }

    @Override
    public String vaultPath(String kafkaTopicName) {
        return this.vaultPath;
    }

    @Override
    public String encryptionKeyAttributeName(String kafkaTopicName) {
        return Objects.requireNonNullElse(this.encryptionKeyAttributeName, "encryption_key");
    }

    public static class SingleTopicVaultEncryptionKeyProviderConfigBuilder {
        private boolean isEncryptedTopic;
        private String kafkaTopicName;
        private VaultConnectionConfig vaultConnectionConfig;
        private String vaultPath;
        private String encryptionKeyAttributeName;

        public SingleTopicVaultEncryptionKeyProviderConfigBuilder kafkaTopicName(String kafkaTopicName) {
            this.kafkaTopicName = kafkaTopicName;
            return this;
        }

        public SingleTopicVaultEncryptionKeyProviderConfigBuilder isEncryptedTopic(boolean isEncryptedTopic) {
            this.isEncryptedTopic = isEncryptedTopic;
            return this;
        }

        public SingleTopicVaultEncryptionKeyProviderConfigBuilder vaultConnectionConfig(VaultConnectionConfig vaultConnectionConfig) {
            this.vaultConnectionConfig = vaultConnectionConfig;
            return this;
        }

        public SingleTopicVaultEncryptionKeyProviderConfigBuilder vaultPath(String vaultPath) {
            this.vaultPath = vaultPath;
            return this;
        }

        public SingleTopicVaultEncryptionKeyProviderConfigBuilder encryptionKeyAttributeName(String encryptionKeyAttributeName) {
            this.encryptionKeyAttributeName = encryptionKeyAttributeName;
            return this;
        }

        public SingleTopicVaultEncryptionKeyProviderConfig build() {
            return new SingleTopicVaultEncryptionKeyProviderConfig(this.isEncryptedTopic, this.kafkaTopicName, this.vaultConnectionConfig, this.vaultPath, this.encryptionKeyAttributeName);
        }
    }
}

