/*
 * Decompiled with CFR 0.152.
 */
package de.otto.kafka.messaging.e2ee.vault;

import de.otto.kafka.messaging.e2ee.EncryptionKeyProvider;
import de.otto.kafka.messaging.e2ee.vault.SecondLevelCacheStorage;
import de.otto.kafka.messaging.e2ee.vault.VaultRuntimeException;
import io.github.jopenlibs.vault.json.Json;
import io.github.jopenlibs.vault.json.JsonArray;
import io.github.jopenlibs.vault.json.JsonObject;
import io.github.jopenlibs.vault.json.JsonValue;
import io.github.jopenlibs.vault.json.WriterConfig;
import java.time.Clock;
import java.time.Duration;
import java.time.OffsetDateTime;
import java.time.ZoneOffset;
import java.time.format.DateTimeFormatter;
import java.time.temporal.ChronoUnit;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import java.util.Objects;
import java.util.concurrent.locks.ReentrantLock;
import java.util.function.Predicate;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class CachedEncryptionKeyProvider
implements EncryptionKeyProvider {
    private static final DateTimeFormatter DTF = DateTimeFormatter.ofPattern("yyyy-MM-dd'T'HH:mmX");
    private static final Logger log = LoggerFactory.getLogger(CachedEncryptionKeyProvider.class);
    private static final String NAME_ENTRIES = "entries";
    private static final String NAME_TOPIC = "topic";
    private static final String NAME_VERSION = "version";
    private static final String NAME_ENCRYPTION_KEY_ATTRIBUTE_NAME = "encryptionKeyAttributeName";
    private static final String NAME_ENCODED_KEY = "encodedKey";
    private static final String NAME_EXPIRE_AT = "expireAt";
    private final ReentrantLock lock = new ReentrantLock();
    private final EncryptionKeyProvider realEncryptionKeyProvider;
    private final SecondLevelCacheStorage cacheStorage;
    private final Clock clock;
    private final Duration cachingDuration;

    public CachedEncryptionKeyProvider(EncryptionKeyProvider realEncryptionKeyProvider, SecondLevelCacheStorage cacheStorage, Duration cachingDuration) {
        this(realEncryptionKeyProvider, cacheStorage, Clock.systemDefaultZone(), cachingDuration);
    }

    public CachedEncryptionKeyProvider(EncryptionKeyProvider realEncryptionKeyProvider, SecondLevelCacheStorage cacheStorage, Clock clock, Duration cachingDuration) {
        this.realEncryptionKeyProvider = Objects.requireNonNull(realEncryptionKeyProvider, "realEncryptionKeyProvider is required");
        this.cacheStorage = Objects.requireNonNull(cacheStorage, "cacheStorage is required");
        this.clock = Objects.requireNonNull(clock, "clock is required");
        this.cachingDuration = Objects.requireNonNull(cachingDuration, "cachingDuration is required");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public EncryptionKeyProvider.KeyVersion retrieveKeyForEncryption(String topic) {
        this.lock.lock();
        try {
            EncryptionKeyProvider.KeyVersion keyVersion;
            String expiredAtTimestampString;
            JsonObject cachedKeyEntry;
            EncryptionKeyProvider.KeyVersion cachedKeyVersion;
            List<JsonObject> cacheEntries;
            block17: {
                String encodedKey;
                cacheEntries = this.loadCacheEntries();
                cachedKeyVersion = null;
                cachedKeyEntry = this.findAtMostOneEntry(cacheEntries, entry -> Objects.equals(topic, entry.getString(NAME_TOPIC)) && entry.getString(NAME_ENCRYPTION_KEY_ATTRIBUTE_NAME) != null && entry.getString(NAME_EXPIRE_AT) != null, this.sortByVersion());
                if (cachedKeyEntry != null) {
                    int version = cachedKeyEntry.getInt(NAME_VERSION);
                    String encryptionKeyAttributeName = cachedKeyEntry.getString(NAME_ENCRYPTION_KEY_ATTRIBUTE_NAME);
                    encodedKey = cachedKeyEntry.getString(NAME_ENCODED_KEY);
                    cachedKeyVersion = new EncryptionKeyProvider.KeyVersion(version, encryptionKeyAttributeName, encodedKey);
                    OffsetDateTime latestKeyVersionExpiredAt = OffsetDateTime.parse(cachedKeyEntry.getString(NAME_EXPIRE_AT), DTF).plus(Math.round(Math.random() * 120000.0), ChronoUnit.MILLIS);
                    if (OffsetDateTime.now(this.clock).isBefore(latestKeyVersionExpiredAt)) {
                        log.debug("use cached key version for topic {}", (Object)topic);
                        EncryptionKeyProvider.KeyVersion keyVersion2 = cachedKeyVersion;
                        return keyVersion2;
                    }
                }
                expiredAtTimestampString = this.retrieveNewExpiredAtTimestamp();
                keyVersion = this.realEncryptionKeyProvider.retrieveKeyForEncryption(topic);
                if (keyVersion != null) break block17;
                encodedKey = null;
                return encodedKey;
            }
            try {
                if (cachedKeyEntry == null || !keyVersion.equals(cachedKeyVersion)) {
                    JsonObject jsonObjectSingleKeyVersion = new JsonObject();
                    jsonObjectSingleKeyVersion.add(NAME_TOPIC, Json.value((String)topic));
                    jsonObjectSingleKeyVersion.add(NAME_VERSION, Json.value((int)keyVersion.version()));
                    jsonObjectSingleKeyVersion.add(NAME_ENCRYPTION_KEY_ATTRIBUTE_NAME, Json.value((String)Objects.requireNonNull(keyVersion.encryptionKeyAttributeName())));
                    jsonObjectSingleKeyVersion.add(NAME_ENCODED_KEY, Json.value((String)keyVersion.encodedKey()));
                    jsonObjectSingleKeyVersion.add(NAME_EXPIRE_AT, Json.value((String)expiredAtTimestampString));
                    cacheEntries.add(jsonObjectSingleKeyVersion);
                } else {
                    log.debug("update cached key version for topic {} with new expiry date {}", (Object)topic, (Object)expiredAtTimestampString);
                    cachedKeyEntry.set(NAME_EXPIRE_AT, Json.value((String)expiredAtTimestampString));
                }
            }
            catch (Exception ex) {
                if (cachedKeyEntry == null) {
                    throw ex;
                }
                log.warn("Retrieval of Vault EncryptionKey failed. Use cached EncryptionKey instead.", (Throwable)ex);
                cachedKeyEntry.set(NAME_EXPIRE_AT, Json.value((String)expiredAtTimestampString));
                keyVersion = cachedKeyVersion;
            }
            JsonArray jsonArrayEntries = new JsonArray();
            for (JsonValue jsonValue : cacheEntries) {
                jsonArrayEntries.add(jsonValue);
            }
            JsonObject jsonObjectRoot = new JsonObject();
            jsonObjectRoot.add(NAME_ENTRIES, (JsonValue)jsonArrayEntries);
            String string = jsonObjectRoot.toString(WriterConfig.MINIMAL);
            try {
                this.cacheStorage.storeEntry(string);
            }
            catch (Exception ex) {
                if (log.isDebugEnabled()) {
                    log.debug(ex.getMessage(), (Throwable)ex);
                }
                log.warn("Failed to store 2nd-level cache value. Error: {}", (Object)ex.getMessage());
            }
            EncryptionKeyProvider.KeyVersion keyVersion2 = keyVersion;
            return keyVersion2;
        }
        finally {
            this.lock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public String retrieveKeyForDecryption(String topic, int version) {
        this.lock.lock();
        try {
            List<JsonObject> cacheEntries = this.loadCacheEntries();
            JsonObject cachedKeyEntry = this.findAtMostOneEntry(cacheEntries, entry -> Objects.equals(topic, entry.getString(NAME_TOPIC)) && version == entry.getInt(NAME_VERSION) && entry.getString(NAME_ENCRYPTION_KEY_ATTRIBUTE_NAME) == null, this.noSortOrder());
            if (cachedKeyEntry != null) {
                String string = cachedKeyEntry.getString(NAME_ENCODED_KEY);
                return string;
            }
            String encodedKey = this.realEncryptionKeyProvider.retrieveKeyForDecryption(topic, version);
            JsonObject jsonObjectSingleKeyVersion = new JsonObject();
            jsonObjectSingleKeyVersion.add(NAME_TOPIC, Json.value((String)topic));
            jsonObjectSingleKeyVersion.add(NAME_VERSION, Json.value((int)version));
            jsonObjectSingleKeyVersion.add(NAME_ENCODED_KEY, Json.value((String)encodedKey));
            cacheEntries.add(jsonObjectSingleKeyVersion);
            JsonArray jsonArrayEntries = new JsonArray();
            for (JsonValue jsonValue : cacheEntries) {
                jsonArrayEntries.add(jsonValue);
            }
            JsonObject jsonObjectRoot = new JsonObject();
            jsonObjectRoot.add(NAME_ENTRIES, (JsonValue)jsonArrayEntries);
            String string = jsonObjectRoot.toString(WriterConfig.MINIMAL);
            try {
                this.cacheStorage.storeEntry(string);
            }
            catch (Exception ex) {
                if (log.isDebugEnabled()) {
                    log.debug(ex.getMessage(), (Throwable)ex);
                }
                log.warn("Failed to store 2nd-level cache value. Error: {}", (Object)ex.getMessage());
            }
            String string2 = encodedKey;
            return string2;
        }
        finally {
            this.lock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public String retrieveKeyForDecryption(String topic, int version, String encryptionKeyAttributeName) {
        this.lock.lock();
        try {
            List<JsonObject> cacheEntries = this.loadCacheEntries();
            JsonObject cachedKeyEntry = this.findAtMostOneEntry(cacheEntries, entry -> Objects.equals(topic, entry.getString(NAME_TOPIC)) && version == entry.getInt(NAME_VERSION) && Objects.equals(encryptionKeyAttributeName, entry.getString(NAME_ENCRYPTION_KEY_ATTRIBUTE_NAME)), this.noSortOrder());
            if (cachedKeyEntry != null) {
                String string = cachedKeyEntry.getString(NAME_ENCODED_KEY);
                return string;
            }
            String encodedKey = this.realEncryptionKeyProvider.retrieveKeyForDecryption(topic, version, encryptionKeyAttributeName);
            JsonObject jsonObjectSingleKeyVersion = new JsonObject();
            jsonObjectSingleKeyVersion.add(NAME_TOPIC, Json.value((String)topic));
            jsonObjectSingleKeyVersion.add(NAME_VERSION, Json.value((int)version));
            jsonObjectSingleKeyVersion.add(NAME_ENCRYPTION_KEY_ATTRIBUTE_NAME, Json.value((String)Objects.requireNonNull(encryptionKeyAttributeName)));
            jsonObjectSingleKeyVersion.add(NAME_ENCODED_KEY, Json.value((String)encodedKey));
            cacheEntries.add(jsonObjectSingleKeyVersion);
            JsonArray jsonArrayEntries = new JsonArray();
            for (JsonValue jsonValue : cacheEntries) {
                jsonArrayEntries.add(jsonValue);
            }
            JsonObject jsonObjectRoot = new JsonObject();
            jsonObjectRoot.add(NAME_ENTRIES, (JsonValue)jsonArrayEntries);
            String string = jsonObjectRoot.toString(WriterConfig.MINIMAL);
            this.cacheStorage.storeEntry(string);
            String string2 = encodedKey;
            return string2;
        }
        finally {
            this.lock.unlock();
        }
    }

    @Override
    public boolean isEncryptedTopic(String kafkaTopicName) {
        return this.realEncryptionKeyProvider.isEncryptedTopic(kafkaTopicName);
    }

    private String retrieveNewExpiredAtTimestamp() {
        return OffsetDateTime.now(this.clock).withOffsetSameInstant(ZoneOffset.UTC).plus(this.cachingDuration).format(DTF);
    }

    private List<JsonObject> loadCacheEntries() {
        String cachedPayload = null;
        try {
            cachedPayload = this.cacheStorage.retrieveEntry();
        }
        catch (Exception ex) {
            if (log.isDebugEnabled()) {
                log.debug(ex.getMessage(), (Throwable)ex);
            }
            log.warn("Failed to load 2nd-level cache value. Error: {}", (Object)ex.getMessage());
        }
        if (cachedPayload == null || cachedPayload.isEmpty()) {
            return new ArrayList<JsonObject>();
        }
        JsonObject jsonObjectRoot = Json.parse((String)cachedPayload).asObject();
        if (jsonObjectRoot.get(NAME_ENTRIES) == null) {
            return new ArrayList<JsonObject>();
        }
        JsonArray jsonArrayEntries = jsonObjectRoot.get(NAME_ENTRIES).asArray();
        ArrayList<JsonObject> cacheEntries = new ArrayList<JsonObject>();
        for (JsonValue jsonValue : jsonArrayEntries.values()) {
            cacheEntries.add(jsonValue.asObject());
        }
        return cacheEntries;
    }

    private Comparator<JsonObject> sortByVersion() {
        return Comparator.comparingInt(entry -> entry.getInt(NAME_VERSION));
    }

    private Comparator<JsonObject> noSortOrder() {
        return Comparator.comparingInt(entry -> 0);
    }

    private JsonObject findAtMostOneEntry(List<JsonObject> values, Predicate<JsonObject> filter, Comparator<JsonObject> comparator) {
        JsonObject currentBestValue = null;
        ArrayList<JsonObject> matchingCurrentBestValues = new ArrayList<JsonObject>();
        for (JsonObject singleValue : values) {
            if (!filter.test(singleValue)) continue;
            int compValue = -1;
            if (currentBestValue != null) {
                compValue = comparator.compare(currentBestValue, singleValue);
            }
            if (compValue < 0) {
                matchingCurrentBestValues.clear();
                matchingCurrentBestValues.add(singleValue);
                currentBestValue = singleValue;
                continue;
            }
            if (compValue != 0) continue;
            matchingCurrentBestValues.add(singleValue);
        }
        if (matchingCurrentBestValues.size() > 1) {
            throw new VaultRuntimeException("None deterministic encryption key. May clear your 2nd-Level-Cache to resolve the issue.");
        }
        return currentBestValue;
    }
}

