/*
 * Decompiled with CFR 0.152.
 */
package de.otto.kafka.messaging.e2ee;

import java.util.Objects;

public interface EncryptionKeyProvider {
    public KeyVersion retrieveKeyForEncryption(String var1);

    public String retrieveKeyForDecryption(String var1, int var2);

    public String retrieveKeyForDecryption(String var1, int var2, String var3);

    default public boolean isEncryptedTopic(String kafkaTopicName) {
        throw new UnsupportedOperationException("This method is not implemented by " + this.getClass().getName());
    }

    public static final class KeyVersion {
        private final int version;
        private final String encryptionKeyAttributeName;
        private final String encodedKey;

        public KeyVersion(int version, String encodedKey) {
            Objects.requireNonNull(encodedKey);
            this.version = version;
            this.encryptionKeyAttributeName = null;
            this.encodedKey = encodedKey;
        }

        public KeyVersion(int version, String encryptionKeyAttributeName, String encodedKey) {
            Objects.requireNonNull(encodedKey);
            this.version = version;
            this.encryptionKeyAttributeName = encryptionKeyAttributeName;
            this.encodedKey = encodedKey;
        }

        public int version() {
            return this.version;
        }

        public String encryptionKeyAttributeName() {
            return this.encryptionKeyAttributeName;
        }

        public String encodedKey() {
            return this.encodedKey;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            KeyVersion that = (KeyVersion)o;
            return this.version == that.version && Objects.equals(this.encryptionKeyAttributeName, that.encryptionKeyAttributeName) && Objects.equals(this.encodedKey, that.encodedKey);
        }

        public int hashCode() {
            return Objects.hash(this.version, this.encryptionKeyAttributeName, this.encodedKey);
        }
    }
}

