/*
 * Decompiled with CFR 0.152.
 */
package de.otto.kafka.messaging.e2ee;

import java.security.GeneralSecurityException;
import java.security.Key;
import java.time.Duration;
import javax.crypto.Cipher;
import javax.crypto.spec.GCMParameterSpec;

interface DefaultAesEncryptionConfiguration {
    public static final String CIPHER_TYPE = "AES/GCM/NoPadding";
    public static final int GCM_IV_SIZE = 12;
    public static final int GCM_TAG_SIZE = 128;
    public static final Duration CACHING_DURATION = Duration.ofMinutes(60L);

    public static byte[] encrypt(byte[] plainValue, Key aesKey, byte[] iv) {
        try {
            Cipher cipher = Cipher.getInstance(CIPHER_TYPE);
            cipher.init(1, aesKey, new GCMParameterSpec(128, iv));
            return cipher.doFinal(plainValue);
        }
        catch (GeneralSecurityException ex) {
            throw new IllegalArgumentException(ex);
        }
    }

    public static byte[] decrypt(byte[] encryptedValue, Key aesKey, byte[] iv) {
        try {
            Cipher cipher = Cipher.getInstance(CIPHER_TYPE);
            cipher.init(2, aesKey, new GCMParameterSpec(128, iv));
            return cipher.doFinal(encryptedValue);
        }
        catch (GeneralSecurityException ex) {
            throw new IllegalArgumentException(ex);
        }
    }
}

