/*
 * Decompiled with CFR 0.152.
 */
package de.otto.kafka.messaging.e2ee;

import de.otto.kafka.messaging.e2ee.EncryptionCipherSpec;
import de.otto.kafka.messaging.e2ee.EncryptionKeyProvider;
import java.util.Base64;
import java.util.Objects;

public final class AesEncryptedPayload {
    private final byte[] encryptedPayload;
    private final byte[] initializationVector;
    private final int keyVersion;
    private final String encryptionKeyAttributeName;

    public AesEncryptedPayload(byte[] plainPayload) {
        this.encryptedPayload = plainPayload;
        this.initializationVector = null;
        this.keyVersion = 0;
        this.encryptionKeyAttributeName = null;
    }

    public AesEncryptedPayload(byte[] encryptedPayload, byte[] initializationVector, int keyVersion) {
        this(encryptedPayload, initializationVector, keyVersion, null);
    }

    public AesEncryptedPayload(byte[] encryptedPayload, byte[] initializationVector, int keyVersion, String encryptionKeyAttributeName) {
        Objects.requireNonNull(encryptedPayload, "encryptedPayload must not be null");
        Objects.requireNonNull(initializationVector, "initializationVector must not be null");
        this.encryptedPayload = encryptedPayload;
        this.initializationVector = initializationVector;
        this.keyVersion = keyVersion;
        this.encryptionKeyAttributeName = encryptionKeyAttributeName;
    }

    public AesEncryptedPayload(byte[] encryptedPayload, String initializationVectorBase64, int keyVersion) {
        this(encryptedPayload, initializationVectorBase64, keyVersion, null);
    }

    public AesEncryptedPayload(byte[] encryptedPayload, String initializationVectorBase64, int keyVersion, String encryptionKeyAttributeName) {
        Objects.requireNonNull(encryptedPayload, "encryptedPayload must not be null");
        Objects.requireNonNull(initializationVectorBase64, "initializationVectorBase64 must not be null");
        this.encryptedPayload = encryptedPayload;
        this.initializationVector = Base64.getDecoder().decode(initializationVectorBase64);
        this.keyVersion = keyVersion;
        this.encryptionKeyAttributeName = encryptionKeyAttributeName;
    }

    public static AesEncryptedPayload ofUnencryptedPayload(byte[] plainPayload) {
        return new AesEncryptedPayload(plainPayload);
    }

    public static AesEncryptedPayload ofEncryptedPayload(byte[] encryptedPayload, byte[] initializationVector, EncryptionKeyProvider.KeyVersion keyVersion) {
        return new AesEncryptedPayload(encryptedPayload, initializationVector, keyVersion.version(), keyVersion.encryptionKeyAttributeName());
    }

    public static AesEncryptedPayload ofEncryptedPayload(byte[] encryptedPayload, String initializationVectorBase64, int keyVersion) {
        return new AesEncryptedPayload(encryptedPayload, initializationVectorBase64, keyVersion);
    }

    public static AesEncryptedPayload ofEncryptedPayload(byte[] encryptedPayload, String initializationVectorBase64, int keyVersion, String encryptionKeyAttributeName) {
        return new AesEncryptedPayload(encryptedPayload, initializationVectorBase64, keyVersion, encryptionKeyAttributeName);
    }

    public static AesEncryptedPayload ofEncryptedPayload(byte[] encryptedPayload, byte[] initializationVector, EncryptionCipherSpec cipherSpec) {
        if (cipherSpec == null) {
            return AesEncryptedPayload.ofUnencryptedPayload(encryptedPayload);
        }
        return new AesEncryptedPayload(encryptedPayload, initializationVector, cipherSpec.keyVersion(), cipherSpec.cipherName());
    }

    public static AesEncryptedPayload ofEncryptedPayload(byte[] encryptedPayload, String initializationVectorBase64, EncryptionCipherSpec cipherSpec) {
        if (cipherSpec == null) {
            return AesEncryptedPayload.ofUnencryptedPayload(encryptedPayload);
        }
        return new AesEncryptedPayload(encryptedPayload, initializationVectorBase64, cipherSpec.keyVersion(), cipherSpec.cipherName());
    }

    public boolean isEncrypted() {
        return this.initializationVector != null && this.initializationVector.length > 0 && this.keyVersion > 0;
    }

    public byte[] encryptedPayload() {
        return this.encryptedPayload;
    }

    public byte[] initializationVector() {
        return this.initializationVector;
    }

    public String initializationVectorBase64() {
        if (this.initializationVector == null) {
            return null;
        }
        return Base64.getEncoder().encodeToString(this.initializationVector);
    }

    public int keyVersion() {
        return this.keyVersion;
    }

    public String encryptionKeyAttributeName() {
        return this.encryptionKeyAttributeName;
    }

    public String toString() {
        if (this.isEncrypted()) {
            return "AesEncryptedPayload{encryptedPayload=" + Base64.getEncoder().encodeToString(this.encryptedPayload) + ", initializationVector=" + Base64.getEncoder().encodeToString(this.initializationVector) + ", keyVersion=" + this.keyVersion + ", encryptionKeyAttributeName=" + this.encryptionKeyAttributeName + "}";
        }
        return "AesEncryptedPayload{payload=" + Base64.getEncoder().encodeToString(this.encryptedPayload) + "}";
    }
}

