/*
 * Decompiled with CFR 0.152.
 */
package de.otto.kafka.messaging.e2ee;

import de.otto.kafka.messaging.e2ee.AesEncryptedPayload;
import de.otto.kafka.messaging.e2ee.Cache;
import de.otto.kafka.messaging.e2ee.DefaultAesEncryptionConfiguration;
import de.otto.kafka.messaging.e2ee.EncryptionKeyProvider;
import de.otto.kafka.messaging.e2ee.vault.VaultHelper;
import java.nio.charset.StandardCharsets;
import java.security.Key;
import java.util.Objects;
import javax.crypto.spec.SecretKeySpec;

public final class DecryptionService {
    private final EncryptionKeyProvider encryptionKeyProvider;
    private final Cache<TopicKeyVersion, Key> aesKeyCache;

    public DecryptionService(EncryptionKeyProvider encryptionKeyProvider) {
        Objects.requireNonNull(encryptionKeyProvider, "encryptionKeyProvider");
        this.encryptionKeyProvider = encryptionKeyProvider;
        this.aesKeyCache = new Cache(DefaultAesEncryptionConfiguration.CACHING_DURATION);
    }

    public byte[] decryptToByteArray(String kafkaTopicName, AesEncryptedPayload encryptedPayload) {
        Objects.requireNonNull(kafkaTopicName, "kafkaTopicName must not be null");
        Objects.requireNonNull(encryptedPayload, "encryptedPayload must not be null");
        if (!encryptedPayload.isEncrypted()) {
            return encryptedPayload.encryptedPayload();
        }
        TopicKeyVersion topicKeyVersion = new TopicKeyVersion(kafkaTopicName, encryptedPayload.keyVersion(), encryptedPayload.encryptionKeyAttributeName());
        Key aesKey = this.aesKeyCache.getOrRetrieve(topicKeyVersion, this::createAesKey);
        byte[] iv = encryptedPayload.initializationVector();
        byte[] encryptedData = encryptedPayload.encryptedPayload();
        return DefaultAesEncryptionConfiguration.decrypt(encryptedData, aesKey, iv);
    }

    public String decryptToString(String kafkaTopicName, AesEncryptedPayload encryptedPayload) {
        return new String(this.decryptToByteArray(kafkaTopicName, encryptedPayload), StandardCharsets.UTF_8);
    }

    private Key createAesKey(TopicKeyVersion topicKeyVersion) {
        String topic = topicKeyVersion.topic();
        int keyVersionNumber = topicKeyVersion.keyVersionNumber();
        String encryptionKeyAttributeName = topicKeyVersion.encryptionKeyAttributeName();
        String base64Key = topicKeyVersion.encryptionKeyAttributeName() == null ? this.encryptionKeyProvider.retrieveKeyForDecryption(topic, keyVersionNumber) : this.encryptionKeyProvider.retrieveKeyForDecryption(topic, keyVersionNumber, encryptionKeyAttributeName);
        byte[] key = VaultHelper.decodeBase64Key(base64Key);
        return new SecretKeySpec(key, "AES");
    }

    private record TopicKeyVersion(String topic, int keyVersionNumber, String encryptionKeyAttributeName) {
        private TopicKeyVersion {
            Objects.requireNonNull(topic);
        }
    }
}

