/*
 * Decompiled with CFR 0.152.
 */
package de.otto.kafka.messaging.e2ee.vault;

import de.otto.kafka.messaging.e2ee.EncryptionKeyProvider;
import de.otto.kafka.messaging.e2ee.vault.RenewableVault;
import de.otto.kafka.messaging.e2ee.vault.VaultEncryptionKeyProviderConfig;
import de.otto.kafka.messaging.e2ee.vault.VaultRuntimeException;
import io.github.jopenlibs.vault.VaultException;
import io.github.jopenlibs.vault.json.Json;
import io.github.jopenlibs.vault.json.JsonObject;
import io.github.jopenlibs.vault.json.JsonValue;
import io.github.jopenlibs.vault.response.LogicalResponse;
import java.nio.charset.StandardCharsets;
import java.time.OffsetDateTime;
import java.util.Objects;
import java.util.function.Supplier;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class VaultEncryptionKeyProvider
implements EncryptionKeyProvider {
    private static final Logger log = LoggerFactory.getLogger(VaultEncryptionKeyProvider.class);
    private final VaultEncryptionKeyProviderConfig config;
    private RenewableVault vault;

    public VaultEncryptionKeyProvider(VaultEncryptionKeyProviderConfig config) {
        this.config = config;
        this.vault = null;
    }

    @Override
    public EncryptionKeyProvider.KeyVersion retrieveKeyForEncryption(String kafkaTopicName) {
        LogicalResponse response;
        if (!this.config.isEncryptedTopic(kafkaTopicName)) {
            return null;
        }
        String path = this.getPathForTopic(kafkaTopicName);
        try {
            RenewableVault theVault = this.getOrCreateVault();
            response = theVault.read(path);
            this.validateResponse(response, () -> "path '" + path + "'");
        }
        catch (VaultException ex) {
            throw new VaultRuntimeException((Exception)((Object)ex));
        }
        String encryptionKeyAttributeName = this.config.encryptionKeyAttributeName(kafkaTopicName);
        String usedEncryptionKeyAttributeName = Objects.requireNonNullElse(encryptionKeyAttributeName, "encryption_key");
        String key = this.extractEncryptionKeyFromResponse(response, usedEncryptionKeyAttributeName);
        OffsetDateTime createdTime = this.extractCreationTimeFromResponse(response);
        int version = this.extractVersionFromResponse(response);
        if (log.isTraceEnabled()) {
            log.trace("The latest encryption key is {}, version = {}, created at {}", new Object[]{key, version, createdTime});
        } else {
            log.debug("The latest encryption key is ***, version = {}, created at {}", (Object)version, (Object)createdTime);
        }
        return new EncryptionKeyProvider.KeyVersion(version, usedEncryptionKeyAttributeName, key);
    }

    @Override
    public String retrieveKeyForDecryption(String topic, int version) {
        String encryptionKeyAttributeName = this.config.encryptionKeyAttributeName(topic);
        return this.retrieveKeyForDecryption(topic, version, encryptionKeyAttributeName);
    }

    @Override
    public String retrieveKeyForDecryption(String topic, int version, String encryptionKeyAttributeName) {
        LogicalResponse response;
        String path = this.getPathForTopic(topic);
        try {
            RenewableVault theVault = this.getOrCreateVault();
            response = theVault.read(path, version);
            this.validateResponse(response, () -> "path '" + path + "' and version '" + version + "'");
        }
        catch (VaultException ex) {
            throw new VaultRuntimeException((Exception)((Object)ex));
        }
        String usedEncryptionKeyAttributeName = Objects.requireNonNullElse(encryptionKeyAttributeName, "encryption_key");
        return this.extractEncryptionKeyFromResponse(response, usedEncryptionKeyAttributeName);
    }

    private void validateResponse(LogicalResponse response, Supplier<String> errorMsgSupplier) {
        if (log.isTraceEnabled()) {
            log.trace("status = {} / body = {}", (Object)response.getRestResponse().getStatus(), (Object)new String(response.getRestResponse().getBody()));
        } else if (log.isDebugEnabled()) {
            log.debug("status = {} / body = ***", (Object)response.getRestResponse().getStatus());
        }
        if (response.getRestResponse().getStatus() != 200) {
            if (log.isErrorEnabled()) {
                log.error("Vault response. HttpCode={} Response={}", (Object)response.getRestResponse().getStatus(), (Object)new String(response.getRestResponse().getBody()));
            }
            throw new VaultRuntimeException("Vault request failed with HttpCode=" + response.getRestResponse().getStatus() + " for " + errorMsgSupplier.get());
        }
    }

    private String extractEncryptionKeyFromResponse(LogicalResponse response, String encryptionKeyAttributeName) {
        JsonObject dataObject = this.extractDataObjectFromResponse(response);
        JsonValue key = dataObject.get(encryptionKeyAttributeName);
        if (key == null) {
            throw new VaultRuntimeException("Secret does not contain '" + encryptionKeyAttributeName + "'.");
        }
        return key.asString();
    }

    private int extractVersionFromResponse(LogicalResponse response) {
        JsonObject metadata = this.extractMetaDataObjectFromResponse(response);
        Integer version = metadata.getInt("version");
        if (version == null) {
            throw new VaultRuntimeException("Metadata.Version is not valid.");
        }
        return version;
    }

    private OffsetDateTime extractCreationTimeFromResponse(LogicalResponse response) {
        JsonObject metadata = this.extractMetaDataObjectFromResponse(response);
        String secretCreatedTime = metadata.getString("created_time");
        if (secretCreatedTime == null) {
            throw new VaultRuntimeException("Metadata.CreatedTime is not valid.");
        }
        return OffsetDateTime.parse(secretCreatedTime);
    }

    private JsonObject extractDataObjectFromResponse(LogicalResponse response) {
        JsonObject dataObject = response.getDataObject();
        if (dataObject == null) {
            throw new VaultRuntimeException("Secret is not valid. KV has not version 2.");
        }
        return dataObject;
    }

    private JsonObject extractMetaDataObjectFromResponse(LogicalResponse response) {
        String responseText = new String(response.getRestResponse().getBody(), StandardCharsets.UTF_8);
        JsonObject responseObject = Json.parse((String)responseText).asObject();
        JsonValue responseData = responseObject.get("data");
        JsonValue responseMetaData = responseData.asObject().get("metadata");
        if (responseMetaData == null) {
            throw new VaultRuntimeException("Secret is not valid - Missing 'metadata'. KV has not version 2.");
        }
        JsonObject metadata = responseMetaData.asObject();
        if (metadata == null) {
            throw new VaultRuntimeException("Metadata is not valid.");
        }
        return metadata;
    }

    private String getPathForTopic(String kafkaTopicName) {
        return this.config.vaultPath(kafkaTopicName);
    }

    private RenewableVault getOrCreateVault() throws VaultException {
        if (this.vault == null) {
            this.vault = this.config.createRenewableVault();
        }
        return this.vault;
    }
}

