/*
 * Decompiled with CFR 0.152.
 */
package de.otto.kafka.messaging.e2ee.vault;

import de.otto.kafka.messaging.e2ee.vault.VaultConnectionConfig;
import io.github.jopenlibs.vault.Vault;
import io.github.jopenlibs.vault.VaultConfig;
import io.github.jopenlibs.vault.VaultException;
import io.github.jopenlibs.vault.response.AuthResponse;
import io.github.jopenlibs.vault.response.LogicalResponse;
import java.time.LocalDateTime;
import java.util.Objects;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RenewableVault {
    private static final Logger log = LoggerFactory.getLogger(RenewableVault.class);
    private final VaultConnectionConfig.VaultAppRole appRoleConfig;
    private Vault vault;
    private VaultConfig configAuth;
    private boolean isAuthRenewable;
    private LocalDateTime authLeaseValidUntil;

    public RenewableVault(VaultConfig configAuth, VaultConnectionConfig.VaultAppRole appRole) {
        Objects.requireNonNull(configAuth, "configAuth is required");
        Objects.requireNonNull(appRole, "appRole is required");
        this.configAuth = configAuth;
        this.vault = Vault.create((VaultConfig)configAuth);
        this.isAuthRenewable = true;
        this.authLeaseValidUntil = LocalDateTime.now().minusSeconds(5L);
        this.appRoleConfig = appRole;
    }

    public RenewableVault(VaultConfig configAuth) {
        Objects.requireNonNull(configAuth, "configAuth is required");
        this.configAuth = configAuth;
        this.vault = Vault.create((VaultConfig)configAuth);
        this.isAuthRenewable = false;
        this.authLeaseValidUntil = LocalDateTime.now().plusYears(10L);
        this.appRoleConfig = null;
    }

    public LogicalResponse read(String path) throws VaultException {
        this.renewAuthTokenIfNeeded();
        return this.vault.logical().read(path);
    }

    public LogicalResponse read(String path, int version) throws VaultException {
        this.renewAuthTokenIfNeeded();
        return this.vault.logical().read(path, Boolean.valueOf(true), Integer.valueOf(version));
    }

    private void renewAuthTokenIfNeeded() throws VaultException {
        if (this.isAuthRenewable && LocalDateTime.now().isAfter(this.authLeaseValidUntil)) {
            log.debug("Try to renew vault auth token ..");
            AuthResponse authResponse = this.vault.auth().loginByAppRole(this.appRoleConfig.path(), this.appRoleConfig.roleid(), this.appRoleConfig.secretid());
            this.configAuth = this.configAuth.token(authResponse.getAuthClientToken());
            this.vault = Vault.create((VaultConfig)this.configAuth);
            this.isAuthRenewable = authResponse.isAuthRenewable();
            this.authLeaseValidUntil = LocalDateTime.now().plusSeconds(authResponse.getAuthLeaseDuration());
            log.debug("new vault auth token is valid until {}", (Object)this.authLeaseValidUntil);
        }
    }
}

